#version 120

#define HALF_PI 1.570796327

varying vec2 texCoord;
varying vec2 oneTexel;

uniform sampler2D DiffuseSampler;

uniform float Ticks;

uniform vec2 InSize;

float atan2(in float y, in float x){
    return x == 0.0 ? sign(y) * HALF_PI : atan(y, x);
}

void main() {
    vec4 blurred = vec4(0.0);
    float totalStrength = 0.0;
    float totalAlpha = 0.0;
    float totalSamples = 0.0;
    float radius = 100.0;
    vec2 position = texCoord - 0.5;
    float distance = length(position);

    float time = (40 - Ticks);
    float distortion = time / 20.0 * 0.7;
    float angle = atan2(position.y, position.x) - HALF_PI;
    vec2 direction = vec2(cos(angle), sin(angle));
    for (float r = -radius; r <= radius; r += 1.0) {
        vec4 texture = texture2D(DiffuseSampler, texCoord + oneTexel * (r * distance * distance * distortion) * direction);
        float strength = 1.0 - abs(r / radius);

        totalAlpha += texture.a;
        totalSamples += 1.0;
        totalStrength += strength;
        blurred += texture;
    }
    vec3 color = blurred.rgb / (radius * 2.0 + 1.0);
    float lightDistance = clamp(1 - length(texCoord - vec2(0.2, 0.8)), 0.75, 2);
    color *= lightDistance * 1.1;
    totalAlpha *= lightDistance * 0.9;
    gl_FragColor = vec4(color, totalAlpha);
}
