/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.structure;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.data.world.WitcheryStructures;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.gen.feature.WitcheryFeature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece;", "Lnet/minecraft/world/gen/structure/StructureComponentTemplate;", "()V", "templateManager", "Lnet/minecraft/world/gen/structure/template/TemplateManager;", "templateLocation", "Lnet/minecraft/util/ResourceLocation;", "position", "Lnet/minecraft/util/math/BlockPos;", "rotation", "Lnet/minecraft/util/Rotation;", "(Lnet/minecraft/world/gen/structure/template/TemplateManager;Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/Rotation;)V", "groundHeight", "", "addComponentParts", "", "world", "Lnet/minecraft/world/World;", "random", "Ljava/util/Random;", "box", "Lnet/minecraft/world/gen/structure/StructureBoundingBox;", "getGroundHeight", "loadTemplate", "", "readStructureFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "writeStructureToNBT", "BasicStart", "BasicStructure", "WitcheryResurrected"})
public abstract class WitcheryBasicStructurePiece
extends StructureComponentTemplate {
    private ResourceLocation templateLocation;
    private Rotation rotation;
    private int groundHeight;

    private final void loadTemplate(TemplateManager templateManager) {
        ResourceLocation resourceLocation = this.templateLocation;
        if (resourceLocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"templateLocation");
        }
        Template template = templateManager.getTemplate(null, resourceLocation);
        PlacementSettings placementSettings = new PlacementSettings().setReplacedBlock(Blocks.AIR);
        Rotation rotation = this.rotation;
        if (rotation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rotation");
        }
        this.setup(template, this.templatePosition, placementSettings.setRotation(rotation));
    }

    public boolean addComponentParts(@NotNull World world, @NotNull Random random, @NotNull StructureBoundingBox box) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)box, (String)"box");
        if (this.groundHeight < 0) {
            this.groundHeight = this.getGroundHeight(world, box);
            if (this.groundHeight < 0) {
                return true;
            }
            int offset = this.groundHeight - this.boundingBox.maxY + (this.boundingBox.maxY - this.boundingBox.minY) - 2;
            this.boundingBox.offset(0, offset, 0);
            this.templatePosition = this.templatePosition.add(0, offset, 0);
        }
        return super.addComponentParts(world, random, box);
    }

    /*
     * WARNING - void declaration
     */
    private final int getGroundHeight(World world, StructureBoundingBox box) {
        int i = 0;
        int j = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int n = this.boundingBox.minZ;
        int n2 = this.boundingBox.maxZ;
        if (n <= n2) {
            while (true) {
                void k;
                int n3;
                int n4;
                if ((n4 = this.boundingBox.minX) <= (n3 = this.boundingBox.maxX)) {
                    while (true) {
                        void l;
                        pos.setPos((int)l, 64, (int)k);
                        if (box.isVecInside((Vec3i)pos)) {
                            int n5 = WitcheryUtils.getGenerationHeight(world, (BlockPos)pos).getY();
                            WorldProvider worldProvider = world.provider;
                            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                            i += RangesKt.coerceAtLeast((int)n5, (int)(worldProvider.getAverageGroundLevel() - 1));
                            ++j;
                        }
                        if (l == n3) break;
                        ++l;
                    }
                }
                if (k == n2) break;
                ++k;
            }
        }
        return j == 0 ? -1 : i / j;
    }

    protected void writeStructureToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        super.writeStructureToNBT(tag);
        ResourceLocation resourceLocation = this.templateLocation;
        if (resourceLocation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"templateLocation");
        }
        tag.setString("Template", resourceLocation.toString());
        Rotation rotation = this.rotation;
        if (rotation == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rotation");
        }
        tag.setString("Rot", rotation.name());
        tag.setInteger("HPos", this.groundHeight);
    }

    protected void readStructureFromNBT(@NotNull NBTTagCompound tag, @NotNull TemplateManager templateManager) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)templateManager, (String)"templateManager");
        super.readStructureFromNBT(tag, templateManager);
        this.templateLocation = new ResourceLocation(tag.getString("Template"));
        String string = tag.getString("Rot");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tag.getString(\"Rot\")");
        this.rotation = Rotation.valueOf((String)string);
        this.groundHeight = tag.getInteger("HPos");
        this.loadTemplate(templateManager);
    }

    public WitcheryBasicStructurePiece() {
        this.groundHeight = -1;
    }

    public WitcheryBasicStructurePiece(@NotNull TemplateManager templateManager, @NotNull ResourceLocation templateLocation, @NotNull BlockPos position, @NotNull Rotation rotation) {
        Intrinsics.checkParameterIsNotNull((Object)templateManager, (String)"templateManager");
        Intrinsics.checkParameterIsNotNull((Object)templateLocation, (String)"templateLocation");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)rotation, (String)"rotation");
        super(0);
        this.groundHeight = -1;
        this.templateLocation = templateLocation;
        this.rotation = rotation;
        this.templatePosition = position;
        this.loadTemplate(templateManager);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u008c\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012u\u0010\u0007\u001aq\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u00110\b\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0014J8\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0017H\u0016J\u0018\u0010$\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0014J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R}\u0010\u0007\u001aq\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u00110\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece$BasicStructure;", "Lnet/minecraft/world/gen/structure/MapGenStructure;", "Lnet/minecraftforge/fml/common/IWorldGenerator;", "templateLocation", "Lnet/minecraft/util/ResourceLocation;", "spawnRoll", "", "startFactory", "Lkotlin/Function5;", "Lnet/minecraft/world/World;", "Lkotlin/ParameterName;", "name", "world", "Ljava/util/Random;", "random", "x", "z", "Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece$BasicStart;", "(Lnet/minecraft/util/ResourceLocation;ILkotlin/jvm/functions/Function5;)V", "distance", "getDistance", "()I", "canSpawnStructureAtCoords", "", "chunkX", "chunkZ", "generate", "", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "getNearestStructurePos", "Lnet/minecraft/util/math/BlockPos;", "pos", "findUnexplored", "getStructureStart", "isBiomeCategoryValid", "category", "Lnet/minecraftforge/common/BiomeDictionary$Type;", "WitcheryResurrected"})
    public static abstract class BasicStructure
    extends MapGenStructure
    implements IWorldGenerator {
        private final ResourceLocation templateLocation;
        private final int spawnRoll;
        private final Function5<World, Random, Integer, Integer, ResourceLocation, BasicStart> startFactory;

        public final int getDistance() {
            return WitcheryConfigOptions.worldGenDistance + 8;
        }

        @Nullable
        public BlockPos getNearestStructurePos(@NotNull World world, @NotNull BlockPos pos, boolean findUnexplored) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
            this.world = world;
            WorldInfo worldInfo = world.getWorldInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)worldInfo, (String)"world.worldInfo");
            if (worldInfo.isMapFeaturesEnabled()) {
                WorldProvider worldProvider = world.provider;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                if (WitcheryConfigOptions.allowedGenerationDimensions.contains(worldProvider.getDimensionType())) {
                    return BasicStructure.access$findNearestStructurePosBySpacing$s1299742559(world, this, pos, this.getDistance(), this.range, 10387312, false, 100, findUnexplored);
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected boolean canSpawnStructureAtCoords(int chunkX, int chunkZ) {
            BiomeDictionary.Type p1;
            void $this$all$iv;
            int l;
            int k;
            Random random;
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            WorldInfo worldInfo = world.getWorldInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)worldInfo, (String)"world.worldInfo");
            if (!worldInfo.isMapFeaturesEnabled()) return false;
            WorldProvider worldProvider = this.world.provider;
            Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
            if (!WitcheryConfigOptions.allowedGenerationDimensions.contains(worldProvider.getDimensionType())) return false;
            int x = chunkX;
            int z = chunkZ;
            if (x < 0) {
                x -= this.getDistance() - 1;
            }
            if (z < 0) {
                z -= this.getDistance() - 1;
            }
            if ((random = this.world.setRandomSeed(k = x / this.getDistance(), l = z / this.getDistance(), 10387312)).nextInt(WitcheryStructures.INSTANCE.getREGISTRY$WitcheryResurrected().getSize()) != this.spawnRoll) return false;
            k = k * this.getDistance() + random.nextInt(this.getDistance() - 8);
            l = l * this.getDistance() + random.nextInt(this.getDistance() - 8);
            if (chunkX != k) return false;
            if (chunkZ != l) return false;
            Set set2 = BiomeDictionary.getTypes((Biome)this.world.getBiomeForCoordsBody(new BlockPos(chunkX * 16 + 5, 0, chunkZ * 16 + 5)));
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"BiomeDictionary.getTypes\u2026 5, 0, chunkZ * 16 + 5)))");
            Iterable iterable = set2;
            BasicStructure basicStructure = this;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                p1 = (BiomeDictionary.Type)element$iv;
                boolean bl = false;
            } while (basicStructure.isBiomeCategoryValid(p1));
            return false;
        }

        private final boolean isBiomeCategoryValid(BiomeDictionary.Type category) {
            return !WitcheryFeature.EXCLUDED_BIOME_CATEGORIES.contains(category);
        }

        @NotNull
        protected BasicStart getStructureStart(int chunkX, int chunkZ) {
            World world = this.world;
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"world");
            Random random = this.rand;
            Intrinsics.checkExpressionValueIsNotNull((Object)random, (String)"rand");
            return (BasicStart)((Object)this.startFactory.invoke((Object)world, (Object)random, (Object)chunkX, (Object)chunkZ, (Object)this.templateLocation));
        }

        public void generate(@NotNull Random random, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
            Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
            Intrinsics.checkParameterIsNotNull((Object)chunkProvider, (String)"chunkProvider");
            this.generate(world, chunkX, chunkZ, null);
            this.generateStructure(world, random, new ChunkPos(chunkX, chunkZ));
        }

        public BasicStructure(@NotNull ResourceLocation templateLocation, int spawnRoll, @NotNull Function5<? super World, ? super Random, ? super Integer, ? super Integer, ? super ResourceLocation, ? extends BasicStart> startFactory) {
            Intrinsics.checkParameterIsNotNull((Object)templateLocation, (String)"templateLocation");
            Intrinsics.checkParameterIsNotNull(startFactory, (String)"startFactory");
            this.templateLocation = templateLocation;
            this.spawnRoll = spawnRoll;
            this.startFactory = startFactory;
        }

        public static final /* synthetic */ BlockPos access$findNearestStructurePosBySpacing$s1299742559(World p0, MapGenStructure p1, BlockPos p2, int p3, int p4, int p5, boolean p6, int p7, boolean p8) {
            return MapGenStructure.findNearestStructurePosBySpacing((World)p0, (MapGenStructure)p1, (BlockPos)p2, (int)p3, (int)p4, (int)p5, (boolean)p6, (int)p7, (boolean)p8);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0095\u0001\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012d\u0010\f\u001a`\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\rj\u0002`\u0018\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece$BasicStart;", "Lnet/minecraft/world/gen/structure/StructureStart;", "()V", "world", "Lnet/minecraft/world/World;", "random", "Ljava/util/Random;", "x", "", "z", "template", "Lnet/minecraft/util/ResourceLocation;", "pieceFactory", "Lkotlin/Function4;", "Lnet/minecraft/world/gen/structure/template/TemplateManager;", "Lkotlin/ParameterName;", "name", "templateManager", "templateLocation", "Lnet/minecraft/util/math/BlockPos;", "position", "Lnet/minecraft/util/Rotation;", "rotation", "Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece;", "Lnet/msrandom/witchery/world/gen/structure/PieceFactory;", "(Lnet/minecraft/world/World;Ljava/util/Random;IILnet/minecraft/util/ResourceLocation;Lkotlin/jvm/functions/Function4;)V", "Companion", "WitcheryResurrected"})
    public static class BasicStart
    extends StructureStart {
        public static final Companion Companion = new Companion(null);

        public BasicStart() {
        }

        public BasicStart(@NotNull World world, @NotNull Random random, int x, int z, @NotNull ResourceLocation template, @NotNull Function4<? super TemplateManager, ? super ResourceLocation, ? super BlockPos, ? super Rotation, ? extends WitcheryBasicStructurePiece> pieceFactory) {
            Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
            Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
            Intrinsics.checkParameterIsNotNull((Object)template, (String)"template");
            Intrinsics.checkParameterIsNotNull(pieceFactory, (String)"pieceFactory");
            super(x, z);
            TemplateManager templateManager = ((WorldServer)world).getStructureTemplateManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)templateManager, (String)"(world as WorldServer).structureTemplateManager");
            this.components.add(pieceFactory.invoke((Object)templateManager, (Object)template, (Object)new BlockPos(x * 16, 0, z * 16), (Object)WitcheryFeature.Companion.getRotation(random)));
        }

        @JvmStatic
        @NotNull
        protected static final String findType(@NotNull World world, @NotNull BlockPos position) {
            return Companion.findType(world, position);
        }

        @JvmStatic
        @NotNull
        protected static final Function4<TemplateManager, ResourceLocation, BlockPos, Rotation, WitcheryBasicStructurePiece> getTypedFactory(@NotNull World world, @NotNull Function4<? super TemplateManager, ? super ResourceLocation, ? super BlockPos, ? super Rotation, ? extends WitcheryBasicStructurePiece> pieceFactory) {
            int $i$f$getTypedFactory = 0;
            return Companion.access$getTypedFactory((Companion)Companion, (World)world, pieceFactory);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0005J\u00d7\u0001\u0010\t\u001a`\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\nj\u0002`\u00142\u0006\u0010\u0005\u001a\u00020\u00062f\b\u0004\u0010\u0015\u001a`\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00130\nj\u0002`\u0014H\u0085\b\u00a8\u0006\u0016"}, d2={"Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece$BasicStart$Companion;", "", "()V", "findType", "", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/BlockPos;", "getTypedFactory", "Lkotlin/Function4;", "Lnet/minecraft/world/gen/structure/template/TemplateManager;", "Lkotlin/ParameterName;", "name", "templateManager", "Lnet/minecraft/util/ResourceLocation;", "templateLocation", "Lnet/minecraft/util/Rotation;", "rotation", "Lnet/msrandom/witchery/world/gen/structure/WitcheryBasicStructurePiece;", "Lnet/msrandom/witchery/world/gen/structure/PieceFactory;", "pieceFactory", "WitcheryResurrected"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            protected final String findType(@NotNull World world, @NotNull BlockPos position) {
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                Set set2 = BiomeDictionary.getTypes((Biome)world.getBiomeForCoordsBody(position.add(5, 0, 5)));
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"BiomeDictionary.getTypes\u2026y(position.add(5, 0, 5)))");
                Set types = set2;
                return types.contains(BiomeDictionary.Type.MESA) ? "mesa" : (types.contains(BiomeDictionary.Type.SANDY) ? "desert" : "plain");
            }

            @JvmStatic
            @NotNull
            protected final Function4<TemplateManager, ResourceLocation, BlockPos, Rotation, WitcheryBasicStructurePiece> getTypedFactory(@NotNull World world, @NotNull Function4<? super TemplateManager, ? super ResourceLocation, ? super BlockPos, ? super Rotation, ? extends WitcheryBasicStructurePiece> pieceFactory) {
                int $i$f$getTypedFactory = 0;
                Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
                Intrinsics.checkParameterIsNotNull(pieceFactory, (String)"pieceFactory");
                return (Function4)new Function4<TemplateManager, ResourceLocation, BlockPos, Rotation, WitcheryBasicStructurePiece>(world, pieceFactory){
                    final /* synthetic */ World $world;
                    final /* synthetic */ Function4 $pieceFactory;

                    @NotNull
                    public final WitcheryBasicStructurePiece invoke(@NotNull TemplateManager templateManager, @NotNull ResourceLocation templateLocation, @NotNull BlockPos position, @NotNull Rotation rotation) {
                        Intrinsics.checkParameterIsNotNull((Object)templateManager, (String)"templateManager");
                        Intrinsics.checkParameterIsNotNull((Object)templateLocation, (String)"templateLocation");
                        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
                        Intrinsics.checkParameterIsNotNull((Object)rotation, (String)"rotation");
                        ResourceLocation location = new ResourceLocation(templateLocation.getNamespace(), templateLocation.getPath() + '/' + BasicStart.Companion.findType(this.$world, position));
                        return (WitcheryBasicStructurePiece)((Object)this.$pieceFactory.invoke((Object)templateManager, (Object)location, (Object)position, (Object)rotation));
                    }
                    {
                        this.$world = world;
                        this.$pieceFactory = function4;
                        super(4);
                    }
                };
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

