/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.init.data.WitcheryLootTables;

public class ComponentVillageWatchTower
extends StructureVillagePieces.Village {
    private boolean hasMadeChest;
    private int guardsSpawned;

    public ComponentVillageWatchTower() {
    }

    public ComponentVillageWatchTower(StructureVillagePieces.Start start, int componentType, StructureBoundingBox bounds, EnumFacing coordMode) {
        super(start, componentType);
        this.setCoordBaseMode(coordMode);
        this.boundingBox = bounds;
    }

    public static ComponentVillageWatchTower createPiece(StructureVillagePieces.Start start, List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4, int p5) {
        StructureBoundingBox bounds = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)8, (int)23, (int)8, (EnumFacing)p4);
        return ComponentVillageWatchTower.canVillageGoDeeper((StructureBoundingBox)bounds) && StructureComponent.findIntersecting(pieces, (StructureBoundingBox)bounds) == null ? new ComponentVillageWatchTower(start, p5, bounds, p4) : null;
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox bounds) {
        int i;
        int height2 = 23;
        if (this.averageGroundLvl < 0) {
            this.averageGroundLvl = this.getAverageGroundLevel(world, bounds);
            if (this.averageGroundLvl < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + height2 - 1, 0);
        }
        IBlockState cobblestone = Blocks.COBBLESTONE.getDefaultState();
        IBlockState planks2 = this.getBiomeSpecificBlockState(Blocks.PLANKS.getDefaultState());
        IBlockState fence2 = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
        this.fillWithBlocks(world, bounds, 2, 0, 2, 6, 17, 6, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 3, 13, 3, 5, 14, 5, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 2, 16, 3, 6, 17, 5, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 3, 16, 2, 5, 17, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 3, 15, 1, 5, 16, 1, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 4, 14, 1, 4, 17, 1, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 3, 15, 7, 5, 16, 7, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 4, 14, 7, 4, 17, 7, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 1, 15, 3, 1, 16, 5, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 1, 14, 4, 1, 17, 4, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 7, 15, 3, 7, 16, 5, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 7, 14, 4, 7, 17, 4, cobblestone, cobblestone, false);
        this.setBlockState(world, fence2, 2, 18, 2, bounds);
        this.setBlockState(world, fence2, 2, 18, 6, bounds);
        this.setBlockState(world, fence2, 6, 18, 2, bounds);
        this.setBlockState(world, fence2, 6, 18, 6, bounds);
        this.fillWithBlocks(world, bounds, 2, 19, 2, 6, 19, 6, planks2, planks2, false);
        this.fillWithBlocks(world, bounds, 3, 20, 3, 5, 20, 5, planks2, planks2, false);
        this.setBlockState(world, planks2, 4, 19, 4, bounds);
        IBlockState stairs2 = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState());
        IBlockState n = stairs2.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH);
        IBlockState s = stairs2.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.SOUTH);
        IBlockState w = stairs2.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST);
        IBlockState e = stairs2.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST);
        this.setBlockState(world, n, 2, 19, 1, bounds);
        this.setBlockState(world, n, 3, 19, 1, bounds);
        this.setBlockState(world, n, 4, 19, 1, bounds);
        this.setBlockState(world, n, 5, 19, 1, bounds);
        this.setBlockState(world, n, 6, 19, 1, bounds);
        this.setBlockState(world, n, 2, 20, 2, bounds);
        this.setBlockState(world, n, 3, 20, 2, bounds);
        this.setBlockState(world, n, 4, 20, 2, bounds);
        this.setBlockState(world, n, 5, 20, 2, bounds);
        this.setBlockState(world, n, 6, 20, 2, bounds);
        this.setBlockState(world, n, 3, 21, 3, bounds);
        this.setBlockState(world, n, 4, 21, 3, bounds);
        this.setBlockState(world, n, 5, 21, 3, bounds);
        this.setBlockState(world, s, 2, 19, 7, bounds);
        this.setBlockState(world, s, 3, 19, 7, bounds);
        this.setBlockState(world, s, 4, 19, 7, bounds);
        this.setBlockState(world, s, 5, 19, 7, bounds);
        this.setBlockState(world, s, 6, 19, 7, bounds);
        this.setBlockState(world, s, 2, 20, 6, bounds);
        this.setBlockState(world, s, 3, 20, 6, bounds);
        this.setBlockState(world, s, 4, 20, 6, bounds);
        this.setBlockState(world, s, 5, 20, 6, bounds);
        this.setBlockState(world, s, 6, 20, 6, bounds);
        this.setBlockState(world, s, 3, 21, 5, bounds);
        this.setBlockState(world, s, 4, 21, 5, bounds);
        this.setBlockState(world, s, 5, 21, 5, bounds);
        this.setBlockState(world, w, 1, 19, 2, bounds);
        this.setBlockState(world, w, 1, 19, 3, bounds);
        this.setBlockState(world, w, 1, 19, 4, bounds);
        this.setBlockState(world, w, 1, 19, 5, bounds);
        this.setBlockState(world, w, 1, 19, 6, bounds);
        this.setBlockState(world, w, 2, 20, 2, bounds);
        this.setBlockState(world, w, 2, 20, 3, bounds);
        this.setBlockState(world, w, 2, 20, 4, bounds);
        this.setBlockState(world, w, 2, 20, 5, bounds);
        this.setBlockState(world, w, 2, 20, 6, bounds);
        this.setBlockState(world, w, 3, 21, 3, bounds);
        this.setBlockState(world, w, 3, 21, 4, bounds);
        this.setBlockState(world, w, 3, 21, 5, bounds);
        this.setBlockState(world, e, 7, 19, 2, bounds);
        this.setBlockState(world, e, 7, 19, 3, bounds);
        this.setBlockState(world, e, 7, 19, 4, bounds);
        this.setBlockState(world, e, 7, 19, 5, bounds);
        this.setBlockState(world, e, 7, 19, 6, bounds);
        this.setBlockState(world, e, 6, 20, 2, bounds);
        this.setBlockState(world, e, 6, 20, 3, bounds);
        this.setBlockState(world, e, 6, 20, 4, bounds);
        this.setBlockState(world, e, 6, 20, 5, bounds);
        this.setBlockState(world, e, 6, 20, 6, bounds);
        this.setBlockState(world, e, 5, 21, 3, bounds);
        this.setBlockState(world, e, 5, 21, 4, bounds);
        this.setBlockState(world, e, 5, 21, 5, bounds);
        this.setBlockState(world, this.getBiomeSpecificBlockState(Blocks.WOODEN_SLAB.getDefaultState()), 4, 22, 4, bounds);
        this.fillWithBlocks(world, bounds, 4, 1, 2, 4, 2, 3, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 3, 2, 4, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 5, 2, 4, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 4, 14, 3, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 4, 16, 4, bounds);
        this.fillWithBlocks(world, bounds, 2, 6, 2, 2, 14, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 6, 6, 2, 6, 14, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 6, 6, 6, 6, 14, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 2, 6, 6, 2, 14, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 4, 6, 2, 4, 12, 2, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 4, 6, 6, 4, 12, 6, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 6, 6, 4, 6, 12, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 2, 6, 4, 2, 12, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 2, 9, 2, 6, 9, 6, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 3, 0, 1, 5, 4, 1, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 4, 1, 1, 4, 3, 1, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 3, 0, 7, 5, 4, 7, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 4, 1, 7, 4, 3, 7, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 1, 0, 3, 1, 4, 5, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 1, 1, 4, 1, 3, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.fillWithBlocks(world, bounds, 7, 0, 3, 7, 4, 5, cobblestone, cobblestone, false);
        this.fillWithBlocks(world, bounds, 7, 1, 4, 7, 3, 4, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        IBlockState offset = Blocks.LADDER.getDefaultState().withProperty((IProperty)BlockLadder.FACING, (Comparable)EnumFacing.SOUTH);
        for (i = 1; i <= 12; ++i) {
            this.setBlockState(world, offset, 4, i, 4, bounds);
        }
        for (i = 13; i <= 15; ++i) {
            this.setBlockState(world, offset, 3, i, 5, bounds);
        }
        if (!this.hasMadeChest) {
            int k;
            i = this.getYWithOffset(13);
            int j = this.getXWithOffset(5, 5);
            if (bounds.isVecInside((Vec3i)new BlockPos(j, i, k = this.getZWithOffset(5, 5)))) {
                this.hasMadeChest = true;
                this.generateChest(world, bounds, rand, 5, 13, 5, WitcheryLootTables.VILLAGE_TOWER);
            }
        }
        for (int l = 1; l < 7; ++l) {
            for (int m = 1; m < 7; ++m) {
                this.clearCurrentPositionBlocksUpwards(world, m, 23, l, bounds);
                this.setBlockState(world, cobblestone, m, -1, l, bounds);
            }
        }
        this.spawnGuards(world, bounds);
        return true;
    }

    protected void writeStructureToNBT(NBTTagCompound nbtRoot) {
        super.writeStructureToNBT(nbtRoot);
        nbtRoot.setBoolean("Chest", this.hasMadeChest);
        nbtRoot.setInteger("Guards", this.guardsSpawned);
    }

    protected void readStructureFromNBT(NBTTagCompound nbtRoot, TemplateManager p_143011_2_) {
        super.readStructureFromNBT(nbtRoot, p_143011_2_);
        this.hasMadeChest = nbtRoot.getBoolean("Chest");
        this.guardsSpawned = nbtRoot.getInteger("Guards");
    }

    private void spawnGuards(World world, StructureBoundingBox bounds) {
        if (this.guardsSpawned < 3) {
            int l1;
            int k1;
            int j1;
            BlockPos pos;
            for (int guardNumber = this.guardsSpawned; guardNumber <= 3 && bounds.isVecInside((Vec3i)(pos = new BlockPos(j1 = this.getXWithOffset(4, 4), k1 = this.getYWithOffset(16), l1 = this.getZWithOffset(4, 4)))); ++guardNumber) {
                ++this.guardsSpawned;
                EntityVillageGuard guard = new EntityVillageGuard(world);
                guard.setLocationAndAngles((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                guard.enablePersistence();
                guard.onInitialSpawn(world.getDifficultyForLocation(pos), null);
                world.spawnEntity((Entity)guard);
            }
        }
    }
}

