/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.msrandom.witchery.entity.EntityVillageGuard;

public class ComponentVillageWall
extends StructureVillagePieces.Village {
    private StructureVillagePieces.Start start;
    private List<StructureComponent> pieces;
    private boolean hasMadeWall;

    public ComponentVillageWall() {
    }

    public ComponentVillageWall(StructureVillagePieces.Start start, int componentType, StructureBoundingBox bounds, EnumFacing baseMode) {
        super(start, componentType);
        this.setCoordBaseMode(baseMode);
        this.boundingBox = bounds;
        this.start = start;
    }

    public static ComponentVillageWall createPiece(StructureVillagePieces.Start start, List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4, int p5) {
        StructureBoundingBox bounds = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)2, (int)7, (int)2, (EnumFacing)p4);
        return ComponentVillageWall.canVillageGoDeeper((StructureBoundingBox)bounds) && StructureComponent.findIntersecting(pieces, (StructureBoundingBox)bounds) == null ? new ComponentVillageWall(start, p5, bounds, p4) : null;
    }

    public void placeWalls(World world, List<StructureBounds> bb, BlockPos coord) {
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (StructureBounds bounds : bb) {
            minX = Math.min(bounds.minX, minX);
            minZ = Math.min(bounds.minZ, minZ);
            maxX = Math.max(bounds.maxX, maxX);
            maxZ = Math.max(bounds.maxZ, maxZ);
        }
        if (maxX != Integer.MIN_VALUE && minX != Integer.MAX_VALUE && maxZ != Integer.MIN_VALUE && minZ != Integer.MAX_VALUE) {
            byte[][] a = new byte[maxX - minX + 3][maxZ - minZ + 3];
            short[][] b = new short[maxX - minX + 3][maxZ - minZ + 3];
            for (StructureBounds structureBounds : bb) {
                int w = structureBounds.maxX - structureBounds.minX + 1;
                int wMid = w / 2 + structureBounds.minX - 1;
                int h = structureBounds.maxZ - structureBounds.minZ + 1;
                int hMid = h / 2 + structureBounds.minZ - 1;
                for (int x = structureBounds.minX; x <= structureBounds.maxX; ++x) {
                    for (int z = structureBounds.minZ; z <= structureBounds.maxZ; ++z) {
                        int mx = x - minX + 1;
                        int mz = z - minZ + 1;
                        a[mx][mz] = !structureBounds.xAxis && (z == structureBounds.minZ || z == structureBounds.maxZ) && x >= wMid - 1 && x <= wMid + 1 ? 3 : (structureBounds.xAxis && (x == structureBounds.minX || x == structureBounds.maxX) && z >= hMid - 1 && z <= hMid + 1 ? 3 : 2);
                    }
                }
            }
            int range = 7;
            for (int x2 = 1; x2 < a.length - range; ++x2) {
                for (int z2 = 1; z2 < a[x2].length - range; ++z2) {
                    if (a[x2][z2] != 2) continue;
                    for (int p = 1; p < range; ++p) {
                        int p2;
                        if (a[x2 + p][z2] == 2 && a[x2 + p - 1][z2] == 0) {
                            for (p2 = p; p2 > 0; --p2) {
                                a[x2 + p2][z2] = 2;
                            }
                        }
                        if (a[x2][z2 + p] != 2 || a[x2][z2 + p - 1] != 0) continue;
                        for (p2 = p; p2 > 0; --p2) {
                            a[x2][z2 + p2] = 2;
                        }
                    }
                }
            }
            for (int x2 = 1; x2 < a.length - 1; ++x2) {
                for (int z2 = 1; z2 < a[x2].length - 1; ++z2) {
                    boolean nw;
                    boolean n = a[x2][z2 - 1] == 0;
                    boolean s = a[x2][z2 + 1] == 0;
                    boolean e = a[x2 + 1][z2] == 0;
                    boolean w2 = a[x2 - 1][z2] == 0;
                    boolean ne = a[x2 + 1][z2 - 1] == 0;
                    boolean sw = a[x2 - 1][z2 + 1] == 0;
                    boolean se = a[x2 + 1][z2 + 1] == 0;
                    boolean bl = nw = a[x2 - 1][z2 - 1] == 0;
                    if (n || s || e || w2 || ne || se || nw || sw) continue;
                    a[x2][z2] = 1;
                }
            }
            IBlockState stateBase = this.getBiomeSpecificBlockState(Blocks.STONEBRICK.getDefaultState());
            IBlockState stateFence = this.getBiomeSpecificBlockState(Blocks.OAK_FENCE.getDefaultState());
            IBlockState stairsBlock = this.getBiomeSpecificBlockState(Blocks.STONE_BRICK_STAIRS.getDefaultState());
            int guardDist = 0;
            for (int x3 = 1; x3 < a.length - 1; ++x3) {
                for (int z3 = 1; z3 < a[x3].length - 1; ++z3) {
                    int lowestY;
                    int dy;
                    boolean nw2;
                    boolean n2 = a[x3][z3 - 1] >= 2;
                    boolean s2 = a[x3][z3 + 1] >= 2;
                    boolean e2 = a[x3 + 1][z3] >= 2;
                    boolean w3 = a[x3 - 1][z3] >= 2;
                    boolean ne2 = a[x3 + 1][z3 - 1] >= 2;
                    boolean sw2 = a[x3 - 1][z3 + 1] >= 2;
                    boolean se2 = a[x3 + 1][z3 + 1] >= 2;
                    boolean bl = nw2 = a[x3 - 1][z3 - 1] >= 2;
                    if (a[x3][z3] < 2) continue;
                    int dx = minX + x3;
                    int dz = minZ + z3;
                    int solidCount = 0;
                    for (dy = coord.getY(); dy > 1 && solidCount < 9; --dy) {
                        solidCount = 0;
                        for (int ddx = dx - 1; ddx <= dx + 1; ++ddx) {
                            for (int ddz = dz - 1; ddz <= dz + 1; ++ddz) {
                                boolean replaceable;
                                IBlockState block = world.getBlockState(new BlockPos(ddx, dy, ddz));
                                boolean bl2 = replaceable = block.getMaterial().isReplaceable() || block.getMaterial() == Material.LEAVES || block.getMaterial() == Material.WOOD || block.getMaterial() == Material.PLANTS;
                                if (!block.isNormalCube() || replaceable) continue;
                                ++solidCount;
                            }
                        }
                    }
                    int minHeight = 9;
                    int startY = dy + minHeight;
                    int near = Math.max(Math.max(Math.max(b[x3 - 1][z3], b[x3 + 1][z3]), b[x3][z3 + 1]), b[x3][z3 - 1]);
                    if (near > 0) {
                        if (near > startY) {
                            startY = near - 1;
                        } else if (near < startY) {
                            startY = near + 1;
                        }
                    }
                    if (startY - (lowestY = dy) > 0) {
                        b[x3][z3] = (short)Math.min(Math.max(startY, 0), Short.MAX_VALUE);
                    }
                    for (dy = startY; dy > lowestY; --dy) {
                        boolean wg;
                        boolean gate;
                        if (dy == startY) {
                            if (!(ne2 || n2 || e2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy + 1, dz - 2, stateBase);
                            }
                            if (!(nw2 || n2 || w3)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz - 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy + 1, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz - 1, stateBase);
                            }
                            if (!(se2 || s2 || e2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz + 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 1, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz + 1, stateBase);
                            }
                            if (!(sw2 || s2 || w3)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz + 1, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 1, dy + 1, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz + 1, stateBase);
                            }
                            if (!(n2 || ne2 || nw2)) {
                                ComponentVillageWall.setBlock(world, dx, dy, dz - 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx, dy + 1, dz - 2, stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST).withProperty((IProperty)BlockStairs.SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT));
                            }
                            if (!(e2 || se2 || ne2)) {
                                ComponentVillageWall.setBlock(world, dx + 2, dy, dz, stateBase);
                                ComponentVillageWall.setBlock(world, dx + 2, dy + 1, dz, stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH));
                            }
                            if (!(s2 || se2 || sw2)) {
                                ComponentVillageWall.setBlock(world, dx, dy, dz + 2, stateBase);
                                ComponentVillageWall.setBlock(world, dx, dy + 1, dz + 2, stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST).withProperty((IProperty)BlockStairs.SHAPE, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT));
                            }
                            if (!(w3 || nw2 || sw2)) {
                                ComponentVillageWall.setBlock(world, dx - 2, dy, dz, stateBase);
                                ComponentVillageWall.setBlock(world, dx - 2, dy + 1, dz, stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH));
                            }
                            if (++guardDist <= 200) continue;
                            ComponentVillageWall.spawnGuard(world, dx, dy, dz);
                            guardDist = 0;
                            continue;
                        }
                        int distCheck = 4;
                        boolean bl3 = gate = a[x3][z3] == 3 && (x3 > distCheck && x3 < a.length - distCheck && a[x3 - distCheck][z3] == 2 && a[x3 + distCheck][z3] == 2 || z3 > distCheck && z3 < a[x3].length - distCheck && a[x3][z3 - distCheck] == 2 && a[x3][z3 + distCheck] == 2);
                        if (gate && dy == startY - 3) {
                            BlockPos pos = new BlockPos(dx, dy, dz);
                            world.setBlockState(pos, stateFence);
                            if (a[x3 + 1][z3] != 3 || a[x3 - 1][z3] != 3) {
                                if (a[x3 + 1][z3] == 3) {
                                    world.setBlockState(pos.north(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP).withProperty((IProperty)BlockStairs.SHAPE, (Comparable)BlockStairs.EnumShape.INNER_LEFT), 2);
                                    world.setBlockState(pos.south(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP).withProperty((IProperty)BlockStairs.SHAPE, (Comparable)BlockStairs.EnumShape.INNER_LEFT), 2);
                                } else if (a[x3 - 1][z3] == 3) {
                                    world.setBlockState(pos.north(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    world.setBlockState(pos.south(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                } else if (a[x3][z3 + 1] != 3 || a[x3][z3 - 1] != 3) {
                                    if (a[x3][z3 - 1] == 3) {
                                        world.setBlockState(pos.west(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                        world.setBlockState(pos.east(), stairsBlock.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH).withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    } else if (a[x3][z3 + 1] == 3) {
                                        world.setBlockState(pos.west(), stairsBlock.withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                        world.setBlockState(pos.east(), stairsBlock.withProperty((IProperty)BlockStairs.HALF, (Comparable)BlockStairs.EnumHalf.TOP), 2);
                                    }
                                }
                            }
                        }
                        if (gate && dy <= startY - 3) continue;
                        ComponentVillageWall.setBlock(world, dx, dy, dz, stateBase);
                        boolean ng = a[x3][z3 - 1] == 3;
                        boolean sg = a[x3][z3 + 1] == 3;
                        boolean eg = a[x3 + 1][z3] == 3;
                        boolean bl4 = wg = a[x3 - 1][z3] == 3;
                        if (!ng) {
                            ComponentVillageWall.setBlock(world, dx, dy, dz - 1, stateBase);
                        }
                        if (!ng && !eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz - 1, stateBase);
                        }
                        if (!ng && !wg) {
                            ComponentVillageWall.setBlock(world, dx - 1, dy, dz - 1, stateBase);
                        }
                        if (!eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz, stateBase);
                        }
                        if (!sg) {
                            ComponentVillageWall.setBlock(world, dx, dy, dz + 1, stateBase);
                        }
                        if (!sg && !eg) {
                            ComponentVillageWall.setBlock(world, dx + 1, dy, dz + 1, stateBase);
                        }
                        if (!sg && !wg) {
                            ComponentVillageWall.setBlock(world, dx - 1, dy, dz + 1, stateBase);
                        }
                        if (wg) continue;
                        ComponentVillageWall.setBlock(world, dx - 1, dy, dz, stateBase);
                    }
                }
            }
        }
    }

    private static void spawnGuard(World world, int x, int y, int z) {
        EntityVillageGuard guard = new EntityVillageGuard(world);
        guard.setLocationAndAngles((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        guard.enablePersistence();
        guard.onInitialSpawn(world.getDifficultyForLocation(guard.getPosition()), null);
        world.spawnEntity((Entity)guard);
    }

    private static void setBlock(World world, int x, int y, int z, IBlockState state) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState replaceState = world.getBlockState(pos);
        Material material = replaceState.getMaterial();
        if (material.isReplaceable() || material == Material.LEAVES || material == Material.WOOD || material == Material.PLANTS) {
            world.setBlockState(pos, state, 2);
        }
    }

    public void buildComponent(StructureComponent component, List<StructureComponent> pieces, Random rand) {
        super.buildComponent(component, pieces, rand);
        this.pieces = pieces;
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox bounds) {
        if (this.averageGroundLvl < 0) {
            this.averageGroundLvl = this.getAverageGroundLevel(world, bounds);
            if (this.averageGroundLvl < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + 7 - 1, 0);
        }
        if (!this.hasMadeWall) {
            int x = 1;
            int z = 1;
            int xCoord = this.getXWithOffset(x, z);
            int yCoord = this.getYWithOffset(1);
            int zCoord = this.getZWithOffset(x, z);
            BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
            if (this.pieces != null && bounds.isVecInside((Vec3i)pos)) {
                this.hasMadeWall = true;
                ArrayList<StructureBounds> bb = new ArrayList<StructureBounds>();
                for (StructureComponent component : this.pieces) {
                    if (!(component instanceof StructureVillagePieces.Path)) continue;
                    bb.add(new StructureBounds((StructureVillagePieces.Path)component, 20, 7));
                }
                this.placeWalls(world, bb, pos);
            }
        }
        return true;
    }

    protected void writeStructureToNBT(NBTTagCompound nbtRoot) {
        super.writeStructureToNBT(nbtRoot);
        nbtRoot.setBoolean("ComponentVillageWall", this.hasMadeWall);
    }

    protected void readStructureFromNBT(NBTTagCompound nbtRoot, TemplateManager p_143011_2_) {
        super.readStructureFromNBT(nbtRoot, p_143011_2_);
        this.hasMadeWall = nbtRoot.getBoolean("ComponentVillageWall");
    }

    public static class StructureBounds
    extends StructureBoundingBox {
        public final boolean xAxis;

        public StructureBounds(StructureVillagePieces.Path path, int expansionX, int expansionZ) {
            this(path.getBoundingBox(), expansionX, expansionZ);
        }

        public StructureBounds(StructureBoundingBox bb, int expansionX, int expansionZ) {
            this(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ, expansionX, expansionZ);
        }

        public StructureBounds(int x, int y, int z, int x2, int y2, int z2, int expansionX, int expansionZ) {
            boolean bl = this.xAxis = x2 - x > z2 - z;
            if (this.xAxis) {
                this.minX = x - expansionZ;
                this.maxX = x2 + expansionZ;
                this.minZ = z - expansionX;
                this.maxZ = z2 + expansionX;
            } else {
                this.minX = x - expansionX;
                this.maxX = x2 + expansionX;
                this.minZ = z - expansionZ;
                this.maxZ = z2 + expansionZ;
            }
            this.minY = y;
            this.maxY = y2;
        }
    }
}

