/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.msrandom.witchery.entity.EntityVillageGuard;
import net.msrandom.witchery.init.data.WitcheryLootTables;

public class ComponentVillageKeep
extends StructureVillagePieces.Village {
    private boolean hasMadeChest;
    private int guardsSpawned;

    public ComponentVillageKeep() {
    }

    public ComponentVillageKeep(StructureVillagePieces.Start start, int componentType, StructureBoundingBox bounds, EnumFacing coordMode) {
        super(start, componentType);
        this.setCoordBaseMode(coordMode);
        this.boundingBox = bounds;
    }

    public static ComponentVillageKeep createPiece(StructureVillagePieces.Start start, List<StructureComponent> pieces, int p1, int p2, int p3, EnumFacing p4, int p5) {
        StructureBoundingBox bounds = StructureBoundingBox.getComponentToAddBoundingBox((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)16, (int)26, (int)16, (EnumFacing)p4);
        return ComponentVillageKeep.canVillageGoDeeper((StructureBoundingBox)bounds) && StructureComponent.findIntersecting(pieces, (StructureBoundingBox)bounds) == null ? new ComponentVillageKeep(start, p5, bounds, p4) : null;
    }

    private void fill(World world, StructureBoundingBox bounds, int x, int y, int z, int w, int h, int d, Block block) {
        IBlockState state = this.getBiomeSpecificBlockState(block.getDefaultState());
        this.fillWithBlocks(world, bounds, x, y, z, x + w - 1, y + h - 1, z + d - 1, state, state, false);
    }

    public boolean addComponentParts(World world, Random rand, StructureBoundingBox bounds) {
        int z;
        int x;
        int h;
        int height2 = 26;
        if (this.averageGroundLvl < 0) {
            this.averageGroundLvl = this.getAverageGroundLevel(world, bounds);
            if (this.averageGroundLvl < 0) {
                return true;
            }
            this.boundingBox.offset(0, this.averageGroundLvl - this.boundingBox.maxY + height2 - 1, 0);
        }
        this.fillWithBlocks(world, bounds, 1, 1, 1, 14, 26, 14, Blocks.AIR.getDefaultState(), Blocks.AIR.getDefaultState(), false);
        this.drawTower(world, bounds, 0, 0);
        this.drawTower(world, bounds, 8, 4);
        this.fill(world, bounds, 7, 0, 2, 3, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 7, 4, 3, 3, 1, 2, Blocks.COBBLESTONE);
        this.fill(world, bounds, 7, 5, 2, 3, 1, 1, Blocks.COBBLESTONE);
        IBlockState cobblestone = this.getBiomeSpecificBlockState(Blocks.COBBLESTONE.getDefaultState());
        IBlockState log2 = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState());
        IBlockState logX = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.X));
        IBlockState logZ = this.getBiomeSpecificBlockState(Blocks.LOG.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.Z));
        this.setBlockState(world, cobblestone, 8, 6, 2, bounds);
        for (int x2 = 7; x2 <= 9; ++x2) {
            this.setBlockState(world, logX, x2, 4, 2, bounds);
        }
        this.fill(world, bounds, 7, 3, 3, 3, 1, 1, Blocks.OAK_FENCE);
        IBlockState slab2 = this.getBiomeSpecificBlockState(Blocks.STONE_SLAB.getDefaultState());
        IBlockState stoneStairs = this.getBiomeSpecificBlockState(Blocks.STONE_STAIRS.getDefaultState());
        this.setBlockState(world, slab2, 7, 3, 2, bounds);
        this.setBlockState(world, slab2, 7, 3, 4, bounds);
        this.setBlockState(world, slab2, 9, 3, 2, bounds);
        this.setBlockState(world, slab2, 9, 3, 4, bounds);
        for (int x3 = 7; x3 <= 9; ++x3) {
            this.setBlockState(world, stoneStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH), x3, 0, 1, bounds);
            this.setBlockState(world, stoneStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.SOUTH), x3, 0, 4, bounds);
        }
        this.fill(world, bounds, 2, 0, 9, 4, 16, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 2, 0, 14, 4, 16, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 1, 0, 10, 1, 16, 4, Blocks.COBBLESTONE);
        this.fill(world, bounds, 6, 0, 10, 1, 16, 4, Blocks.COBBLESTONE);
        this.fill(world, bounds, 2, 0, 10, 4, 1, 4, Blocks.COBBLESTONE);
        this.fill(world, bounds, 1, 4, 9, 6, 1, 6, Blocks.COBBLESTONE);
        this.fill(world, bounds, 1, 9, 9, 6, 1, 6, Blocks.COBBLESTONE);
        this.fill(world, bounds, 1, 14, 9, 6, 1, 6, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3, 16, 9, 2, 1, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3, 16, 14, 2, 1, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 1, 16, 11, 1, 1, 2, Blocks.COBBLESTONE);
        this.fill(world, bounds, 6, 16, 11, 1, 1, 2, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3, 1, 14, 2, 3, 1, Blocks.LOG);
        this.fill(world, bounds, 1, 1, 11, 1, 3, 2, Blocks.LOG);
        this.fill(world, bounds, 3, 11, 9, 2, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 3, 6, 14, 2, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 3, 11, 14, 2, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 1, 6, 11, 1, 2, 2, Blocks.IRON_BARS);
        this.fill(world, bounds, 1, 11, 11, 1, 2, 2, Blocks.IRON_BARS);
        this.fill(world, bounds, 6, 11, 11, 1, 2, 2, Blocks.IRON_BARS);
        this.fill(world, bounds, 4, 1, 9, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 4, 5, 9, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 6, 1, 11, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 6, 5, 11, 1, 2, 1, Blocks.AIR);
        this.setBlockState(world, log2, 4, 7, 9, bounds);
        this.setBlockState(world, logZ, 6, 7, 11, bounds);
        for (h = 1; h <= 14; ++h) {
            this.setBlockState(world, Blocks.LADDER.getDefaultState().withProperty((IProperty)BlockLadder.FACING, (Comparable)EnumFacing.NORTH), 2, h, 10, bounds);
        }
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 2, 2, 13, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 2, 6, 13, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 2, 11, 13, bounds);
        this.fill(world, bounds, 11, 0, 9, 3, 19, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 11, 0, 13, 3, 19, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 10, 0, 10, 1, 19, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 14, 0, 10, 1, 19, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 11, 0, 10, 3, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 10, 4, 9, 5, 1, 5, Blocks.COBBLESTONE);
        this.fill(world, bounds, 10, 9, 9, 5, 1, 5, Blocks.COBBLESTONE);
        this.fill(world, bounds, 10, 14, 9, 5, 1, 5, Blocks.COBBLESTONE);
        this.fill(world, bounds, 10, 19, 9, 5, 1, 5, Blocks.COBBLESTONE);
        this.fill(world, bounds, 12, 1, 13, 1, 3, 1, Blocks.LOG);
        this.fill(world, bounds, 14, 1, 11, 1, 3, 1, Blocks.LOG);
        this.fill(world, bounds, 12, 6, 13, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 12, 11, 9, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 12, 16, 9, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 12, 11, 13, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 12, 16, 13, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 14, 6, 11, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 14, 11, 11, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 14, 16, 11, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 10, 11, 11, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 10, 16, 11, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 12, 5, 9, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 12, 1, 9, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 10, 5, 11, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 10, 1, 11, 1, 2, 1, Blocks.AIR);
        this.setBlockState(world, logX, 12, 7, 9, bounds);
        this.setBlockState(world, logZ, 10, 7, 11, bounds);
        for (h = 1; h <= 14; ++h) {
            this.setBlockState(world, Blocks.LADDER.getDefaultState().withProperty((IProperty)BlockLadder.FACING, (Comparable)EnumFacing.NORTH), 11, h, 10, bounds);
        }
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 11, 2, 12, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 11, 6, 12, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 11, 11, 12, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 11, 16, 12, bounds);
        this.setBlockState(world, log2, 11, 19, 10, bounds);
        this.fill(world, bounds, 10, 20, 9, 5, 2, 5, Blocks.PLANKS);
        this.fill(world, bounds, 11, 22, 10, 3, 2, 3, Blocks.PLANKS);
        this.fill(world, bounds, 12, 24, 11, 1, 2, 1, Blocks.PLANKS);
        this.fill(world, bounds, 11, 20, 10, 3, 2, 3, Blocks.AIR);
        IBlockState oakStairs = this.getBiomeSpecificBlockState(Blocks.OAK_STAIRS.getDefaultState());
        IBlockState n = oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH);
        IBlockState s = oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.SOUTH);
        IBlockState w = oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST);
        IBlockState e = oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST);
        for (x = 9; x <= 15; ++x) {
            this.setBlockState(world, n, x, 20, 8, bounds);
            this.setBlockState(world, s, x, 20, 14, bounds);
        }
        for (x = 10; x <= 14; ++x) {
            this.setBlockState(world, n, x, 22, 9, bounds);
            this.setBlockState(world, s, x, 22, 13, bounds);
        }
        for (x = 11; x <= 13; ++x) {
            this.setBlockState(world, n, x, 24, 10, bounds);
            this.setBlockState(world, s, x, 24, 12, bounds);
        }
        for (z = 9; z <= 13; ++z) {
            this.setBlockState(world, w, 9, 20, z, bounds);
            this.setBlockState(world, e, 15, 20, z, bounds);
        }
        for (z = 10; z <= 12; ++z) {
            this.setBlockState(world, w, 10, 22, z, bounds);
            this.setBlockState(world, e, 14, 22, z, bounds);
        }
        this.setBlockState(world, w, 11, 24, 11, bounds);
        this.setBlockState(world, e, 13, 24, 11, bounds);
        this.fill(world, bounds, 7, 0, 11, 3, 1, 2, Blocks.COBBLESTONE);
        this.fill(world, bounds, 7, 4, 11, 3, 1, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 7, 1, 12, 3, 5, 1, Blocks.COBBLESTONE);
        this.setBlockState(world, cobblestone, 8, 6, 12, bounds);
        this.fill(world, bounds, 7, 1, 12, 1, 4, 1, Blocks.LOG);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 8, 2, 11, bounds);
        this.fill(world, bounds, 9, 1, 12, 1, 4, 1, Blocks.LOG);
        for (x = 7; x <= 9; ++x) {
            this.setBlockState(world, oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.NORTH), x, 0, 10, bounds);
        }
        this.setBlockState(world, slab2, 7, 3, 11, bounds);
        this.setBlockState(world, slab2, 9, 3, 11, bounds);
        this.fill(world, bounds, 3, 0, 6, 2, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 4, 4, 6, 1, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3, 1, 6, 1, 5, 3, Blocks.COBBLESTONE);
        this.setBlockState(world, cobblestone, 3, 6, 7, bounds);
        this.fill(world, bounds, 3, 1, 6, 1, 4, 1, Blocks.LOG);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 4, 2, 7, bounds);
        this.fill(world, bounds, 3, 1, 8, 1, 4, 1, Blocks.LOG);
        for (z = 6; z <= 8; ++z) {
            this.setBlockState(world, oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.EAST), 5, 0, z, bounds);
        }
        this.setBlockState(world, slab2, 4, 3, 6, bounds);
        this.setBlockState(world, slab2, 4, 3, 8, bounds);
        this.fill(world, bounds, 12, 0, 6, 2, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 12, 4, 6, 1, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 13, 1, 6, 1, 5, 3, Blocks.COBBLESTONE);
        this.setBlockState(world, cobblestone, 13, 6, 7, bounds);
        this.fill(world, bounds, 13, 1, 6, 1, 4, 1, Blocks.LOG);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 12, 2, 7, bounds);
        this.fill(world, bounds, 13, 1, 8, 1, 4, 1, Blocks.LOG);
        for (z = 6; z <= 8; ++z) {
            this.setBlockState(world, oakStairs.withProperty((IProperty)BlockStairs.FACING, (Comparable)EnumFacing.WEST), 11, 0, z, bounds);
        }
        this.setBlockState(world, slab2, 12, 3, 6, bounds);
        this.setBlockState(world, slab2, 12, 3, 8, bounds);
        if (!this.hasMadeChest) {
            int k;
            x = 13;
            int z2 = 12;
            int y = 20;
            int i = this.getYWithOffset(y);
            int j = this.getXWithOffset(x, z2);
            if (bounds.isVecInside((Vec3i)new BlockPos(j, i, k = this.getZWithOffset(x, z2)))) {
                this.hasMadeChest = true;
                this.generateChest(world, bounds, rand, x, y, z2, WitcheryLootTables.VILLAGE_KEEP);
            }
        }
        for (int l = 1; l < 15; ++l) {
            for (int m = 1; m < 15; ++m) {
                this.clearCurrentPositionBlocksUpwards(world, m, 26, l, bounds);
                this.setBlockState(world, cobblestone, m, -1, l, bounds);
            }
        }
        this.spawnGuards(world, bounds, 7, 1, 7, 3);
        this.spawnGuards(world, bounds, 5, 10, 4, 4);
        this.spawnGuards(world, bounds, 13, 10, 4, 5);
        return true;
    }

    public void drawTower(World world, StructureBoundingBox bounds, int offsetX, int flipX) {
        this.fill(world, bounds, 3 + offsetX, 0, 1, 3, 11, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3 + offsetX, 0, 5, 3, 11, 1, Blocks.COBBLESTONE);
        this.fill(world, bounds, 2 + offsetX, 0, 2, 1, 11, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 6 + offsetX, 0, 2, 1, 11, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 3 + offsetX, 0, 2, 3, 1, 3, Blocks.COBBLESTONE);
        this.fill(world, bounds, 2 + offsetX, 4, 1, 5, 1, 5, Blocks.COBBLESTONE);
        this.fill(world, bounds, 2 + offsetX, 9, 1, 5, 1, 5, Blocks.COBBLESTONE);
        this.setBlockState(world, Blocks.COBBLESTONE.getDefaultState(), 4 + offsetX, 11, 1, bounds);
        this.setBlockState(world, Blocks.COBBLESTONE.getDefaultState(), 4 + offsetX, 11, 5, bounds);
        this.setBlockState(world, Blocks.COBBLESTONE.getDefaultState(), 2 + offsetX, 11, 3, bounds);
        this.setBlockState(world, Blocks.COBBLESTONE.getDefaultState(), 6 + offsetX, 11, 3, bounds);
        this.fill(world, bounds, 4 + offsetX, 1, 1, 1, 3, 1, Blocks.LOG);
        this.fill(world, bounds, 2 + offsetX + flipX, 1, 3, 1, 3, 1, Blocks.LOG);
        this.fill(world, bounds, 4 + offsetX, 6, 1, 1, 2, 1, Blocks.IRON_BARS);
        this.fill(world, bounds, 2 + offsetX + flipX, 6, 3, 1, 2, 1, Blocks.IRON_BARS);
        this.setBlockState(world, Blocks.LOG.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.X), 4 + offsetX, 7, 5, bounds);
        this.setBlockState(world, Blocks.LOG.getDefaultState().withProperty((IProperty)BlockLog.LOG_AXIS, (Comparable)BlockLog.EnumAxis.Z), 6 + offsetX - flipX, 7, 3, bounds);
        this.fill(world, bounds, 4 + offsetX, 5, 5, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 4 + offsetX, 1, 5, 1, 2, 1, Blocks.AIR);
        this.fill(world, bounds, 6 + offsetX - flipX, 5, 3, 1, 2, 1, Blocks.AIR);
        for (int h = 1; h <= 9; ++h) {
            this.setBlockState(world, Blocks.LADDER.getDefaultState().withProperty((IProperty)BlockLadder.FACING, (Comparable)EnumFacing.NORTH), 3 + offsetX, h, 2, bounds);
        }
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 3 + offsetX, 2, 4, bounds);
        this.setBlockState(world, Blocks.TORCH.getDefaultState(), 3 + offsetX, 6, 4, bounds);
    }

    protected void writeStructureToNBT(NBTTagCompound nbtRoot) {
        super.writeStructureToNBT(nbtRoot);
        nbtRoot.setBoolean("Chest", this.hasMadeChest);
        nbtRoot.setInteger("Guards", this.guardsSpawned);
    }

    protected void readStructureFromNBT(NBTTagCompound nbtRoot, TemplateManager p_143011_2_) {
        super.readStructureFromNBT(nbtRoot, p_143011_2_);
        this.hasMadeChest = nbtRoot.getBoolean("Chest");
        this.guardsSpawned = nbtRoot.getInteger("Guards");
    }

    private void spawnGuards(World world, StructureBoundingBox bounds, int x, int y, int z, int count) {
        if (this.guardsSpawned < count) {
            int l1;
            int k1;
            int j1;
            BlockPos pos;
            for (int guardNumber = this.guardsSpawned; guardNumber <= count && bounds.isVecInside((Vec3i)(pos = new BlockPos(j1 = this.getXWithOffset(x, z), k1 = this.getYWithOffset(y), l1 = this.getZWithOffset(x, z)))); ++guardNumber) {
                ++this.guardsSpawned;
                EntityVillageGuard guard = new EntityVillageGuard(world);
                guard.setLocationAndAngles((double)j1 + 0.5, k1, (double)l1 + 0.5, 0.0f, 0.0f);
                guard.enablePersistence();
                guard.onInitialSpawn(world.getDifficultyForLocation(pos), null);
                world.spawnEntity((Entity)guard);
            }
        }
    }
}

