/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.msrandom.witchery.init.WitcheryWoodTypes;

public class WorldGenRowanTree
extends WorldGenAbstractTree {
    public WorldGenRowanTree() {
        super(true);
    }

    public boolean generate(World par1World, Random par2Random, BlockPos pos) {
        int l = par2Random.nextInt(3) + 5;
        boolean flag = true;
        if (pos.getY() < 1 || pos.getY() + l + 1 > 256) {
            return false;
        }
        for (int i1 = pos.getY(); i1 <= pos.getY() + 1 + l; ++i1) {
            int b0 = 1;
            if (i1 == pos.getY()) {
                b0 = 0;
            }
            if (i1 >= pos.getY() + 1 + l - 2) {
                b0 = 2;
            }
            for (int l2 = pos.getX() - b0; l2 <= pos.getX() + b0 && flag; ++l2) {
                for (int j1 = pos.getZ() - b0; j1 <= pos.getZ() + b0 && flag; ++j1) {
                    if (i1 >= 0 && i1 < 256) {
                        BlockPos p = new BlockPos(l2, i1, j1);
                        IBlockState s = par1World.getBlockState(p);
                        Block block = s.getBlock();
                        boolean isAir = par1World.isAirBlock(p);
                        if (isAir || block.isLeaves(s, (IBlockAccess)par1World, p) || block == Blocks.GRASS || block == Blocks.DIRT || block.isWood((IBlockAccess)par1World, p)) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        IBlockState ss = par1World.getBlockState(pos.down());
        Block soil = ss.getBlock();
        boolean isSoil = soil.canSustainPlant(ss, (IBlockAccess)par1World, pos.down(), EnumFacing.UP, (IPlantable)WitcheryWoodTypes.ROWAN.getSapling());
        if (isSoil && pos.getY() < 256 - l - 1) {
            int j1;
            soil.onPlantGrow(ss, par1World, pos.down(), pos);
            int b0 = 3;
            int b2 = 0;
            for (j1 = pos.getY() - b0 + l; j1 <= pos.getY() + l; ++j1) {
                int k1 = j1 - (pos.getY() + l);
                int i2 = b2 + 1 - k1 / 2 + 1;
                for (int j2 = pos.getX() - i2; j2 <= pos.getX() + i2; ++j2) {
                    int k2 = j2 - pos.getX();
                    for (int l3 = pos.getZ() - i2; l3 <= pos.getZ() + i2; ++l3) {
                        BlockPos bp;
                        IBlockState bs;
                        Block block2;
                        int i3 = l3 - pos.getZ();
                        if (Math.abs(k2) == i2 && Math.abs(i3) == i2 && (par2Random.nextInt(2) == 0 || k1 == 0) || (block2 = (bs = par1World.getBlockState(bp = new BlockPos(j2, j1, l3))).getBlock()) != Blocks.AIR && !block2.canBeReplacedByLeaves(bs, (IBlockAccess)par1World, bp)) continue;
                        this.setBlockAndNotifyAdequately(par1World, bp, WitcheryWoodTypes.ROWAN.getLeaves().getDefaultState());
                    }
                }
            }
            for (j1 = 0; j1 < l; ++j1) {
                IBlockState s3 = par1World.getBlockState(pos.up(j1));
                Block block3 = s3.getBlock();
                if (block3 != Blocks.AIR && !block3.isLeaves(s3, (IBlockAccess)par1World, pos.up(j1))) continue;
                this.setBlockAndNotifyAdequately(par1World, pos.up(j1), WitcheryWoodTypes.ROWAN.getLog().getDefaultState());
            }
            return true;
        }
        return false;
    }
}

