/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen.feature;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.world.gen.feature.WitcheryFeature;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J(\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lnet/msrandom/witchery/world/gen/feature/WispyCottonFeature;", "Lnet/msrandom/witchery/world/gen/feature/WitcheryFeature;", "()V", "canGenerate", "", "world", "Lnet/minecraft/world/World;", "position", "Lnet/minecraft/util/math/BlockPos;", "generate", "", "Lnet/minecraft/world/WorldServer;", "random", "Ljava/util/Random;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "isBiomeCategoryValid", "category", "Lnet/minecraftforge/common/BiomeDictionary$Type;", "WitcheryResurrected"})
public final class WispyCottonFeature
extends WitcheryFeature {
    @Override
    public boolean canGenerate(@NotNull World world, @NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return world.rand.nextInt(4) != 0 && WitcheryDimensions.SPIRIT_WORLD.isCurrentDimension(world);
    }

    @Override
    public boolean isBiomeCategoryValid(@NotNull BiomeDictionary.Type category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        return Intrinsics.areEqual((Object)category, (Object)BiomeDictionary.Type.JUNGLE) || super.isBiomeCategoryValid(category);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generate(@NotNull WorldServer world, @NotNull BlockPos position, @NotNull Random random, @NotNull IChunkGenerator chunkGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        Intrinsics.checkParameterIsNotNull((Object)chunkGenerator, (String)"chunkGenerator");
        int x = position.getX() + random.nextInt(16) + 8;
        int z = position.getZ() + random.nextInt(16) + 8;
        int height2 = random.nextInt(world.getHeight(x, z) + 32);
        int n = 0;
        int n2 = 64;
        while (n < n2) {
            void i;
            BlockPos pos = new BlockPos(x + random.nextInt(8) - random.nextInt(8), height2 + random.nextInt(4) - random.nextInt(4), z + random.nextInt(8) - random.nextInt(8));
            if (world.isAirBlock(pos)) {
                WorldProvider worldProvider = world.provider;
                Intrinsics.checkExpressionValueIsNotNull((Object)worldProvider, (String)"world.provider");
                if ((!worldProvider.isNether() || pos.getY() < 255) && WitcheryBlocks.WISPY_COTTON.canBlockStay((World)world, pos, WitcheryBlocks.WISPY_COTTON.getDefaultState())) {
                    world.setBlockState(pos, WitcheryBlocks.WISPY_COTTON.getDefaultState(), 2);
                }
            }
            ++i;
        }
    }
}

