/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.gen;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.IChunkGenerator;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.world.gen.MazeGenerator;

public class ChunkGeneratorTorment
implements IChunkGenerator {
    public static final int NUM_LEVELS = 6;
    public static final int BASE_LEVEL = 10;
    public static final int LEVEL_HEIGHT = 15;
    public static final int MAZE_SIZE = 31;
    private final World world;

    public ChunkGeneratorTorment(World world) {
        this.world = world;
    }

    public Chunk generateChunk(int x, int z) {
        Chunk chunk = new Chunk(this.world, x, z);
        byte[] abyte = chunk.getBiomeArray();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)Biome.getIdForBiome((Biome)Biomes.HELL);
        }
        for (int y = 0; y < 255; ++y) {
            int l = y >> 4;
            ExtendedBlockStorage extendedblockstorage = chunk.getBlockStorageArray()[l];
            if (extendedblockstorage == null) {
                chunk.getBlockStorageArray()[l] = extendedblockstorage = new ExtendedBlockStorage(y, this.world.provider.hasSkyLight());
            }
            for (int _x = 0; _x < 16; ++_x) {
                for (int _z = 0; _z < 16; ++_z) {
                    Block blockId = Blocks.AIR;
                    extendedblockstorage.set(_x, y & 0xF, _z, blockId.getDefaultState());
                }
            }
        }
        return chunk;
    }

    public void populate(int i, int j) {
        if (i == 0 && j == 0) {
            for (int slot = 0; slot < 6; ++slot) {
                MazeGenerator maze = MazeGenerator.generateMaze(31, 31, this.world.rand);
                maze.display(this.world, -23, 10 + slot * 15, 6, WitcheryBlocks.FORCE, WitcheryBlocks.TORMENT_STONE);
            }
        }
    }

    public boolean generateStructures(Chunk chunk, int i, int i1) {
        return false;
    }

    public boolean isInsideStructure(World world, String s, BlockPos blockPos) {
        return false;
    }

    public List<Biome.SpawnListEntry> getPossibleCreatures(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        return Collections.emptyList();
    }

    public BlockPos getNearestStructurePos(World world, String s, BlockPos pos, boolean unexplored) {
        return null;
    }

    public void recreateStructures(Chunk chunkIn, int i, int j) {
    }
}

