/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.dimension.torment;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.msrandom.witchery.entity.EntityLordOfTorment;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.torment.TormentWorldData;
import net.msrandom.witchery.world.gen.ChunkGeneratorTorment;

public class WorldProviderTorment
extends WorldProvider {
    public static void setPlayerMustTorment(EntityPlayer player, TormentWorldData.TormentType tormentType, int presetLevel) {
        TormentWorldData tormentData = WitcheryUtils.getExtension(player).getTormentData();
        tormentData.setTormentType(tormentType);
        tormentData.setTormentLevel(presetLevel);
    }

    public static int getRandomTormentLevel(World world) {
        return world.rand.nextInt(6);
    }

    public static void updatePlayerEffects(World world, EntityPlayer player, long counter) {
        if (!world.isRemote && counter % 20L == 0L) {
            TormentWorldData tormentData = WitcheryUtils.getExtension(player).getTormentData();
            TormentWorldData.TormentType mustTorment = tormentData.getTormentType();
            if (mustTorment.isBeginning()) {
                int level = mustTorment == TormentWorldData.TormentType.BOSS ? tormentData.getTormentLevel() - 2 : WorldProviderTorment.getRandomTormentLevel(world);
                tormentData.setTormentType(TormentWorldData.TormentType.NONE);
                tormentData.setTormentLevel(1);
                if (player.isRiding()) {
                    player.dismountRidingEntity();
                }
                player.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                int yPos = 12 + level * 15;
                player.setPositionAndUpdate(8.0, (double)yPos, 8.0);
                WitcheryIngredientItem.travelToDimension(player, WitcheryDimensions.TORMENT.getType().getId());
                player.setPositionAndUpdate(8.0, (double)yPos, 8.0);
                player.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                WorldServer tormentWorld = world.getMinecraftServer().getWorld(WitcheryDimensions.TORMENT.getType().getId());
                int midX = 8;
                int midZ = 8;
                for (int x = midX - 1; x <= midX + 1; ++x) {
                    for (int z = midZ - 1; z <= midZ + 1; ++z) {
                        BlockPos pos = new BlockPos(x, yPos, z);
                        if (!tormentWorld.isAirBlock(pos)) {
                            tormentWorld.setBlockToAir(pos);
                        }
                        if (tormentWorld.isAirBlock(pos.up())) continue;
                        tormentWorld.setBlockToAir(pos.up());
                    }
                }
                if (mustTorment == TormentWorldData.TormentType.BOSS) {
                    boolean found = false;
                    if (WitcheryDimensions.TORMENT.isInDimension((Entity)player)) {
                        for (Entity obj : player.world.loadedEntityList) {
                            if (!(obj instanceof EntityLordOfTorment)) continue;
                            EntityLordOfTorment lot = (EntityLordOfTorment)obj;
                            if (!(lot.posY >= (double)(yPos - 2)) || !(lot.posY <= (double)(yPos + 6 - 2))) continue;
                            found = true;
                            break;
                        }
                    }
                    if (!found) {
                        EntityLordOfTorment lot2 = new EntityLordOfTorment((World)tormentWorld);
                        lot2.setPositionAndRotation(9.0, yPos - 1, 36.0, 0.0f, 0.0f);
                        lot2.enablePersistence();
                        lot2.setHealth(lot2.getMaxHealth() * 0.5f);
                        tormentWorld.spawnEntity((Entity)lot2);
                    }
                }
            } else if (mustTorment == TormentWorldData.TormentType.END) {
                tormentData.setTormentType(TormentWorldData.TormentType.NONE);
                tormentData.setTormentLevel(0);
                if (player.isRiding()) {
                    player.dismountRidingEntity();
                }
                WorldServer overworld = player.getServer().worlds[0];
                BlockPos coords = player.getBedLocation(0);
                int dimension = 0;
                if (coords == null) {
                    coords = overworld.getSpawnPoint();
                }
                int mod = 0;
                int origY = coords.getY();
                while (!WorldProviderTorment.isSafeBlock((World)overworld, coords) && coords.getY() > 1 && coords.getY() < 255) {
                    coords = new BlockPos(coords.getX(), mod + origY, coords.getZ());
                    if (origY - mod > 1) {
                        mod = -mod;
                    }
                    if (mod < 0) continue;
                    ++mod;
                }
                player.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
                WitcheryIngredientItem.teleportToLocation(coords.up(), dimension, (Entity)player, true);
                player.playSound(SoundEvents.ENTITY_ENDERMEN_TELEPORT, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)player);
            }
        }
    }

    private static boolean isSafeBlock(World world, BlockPos pos) {
        boolean base = !world.getBlockState(pos).getMaterial().isReplaceable();
        boolean air1 = world.getBlockState(pos.up()).getMaterial().isReplaceable();
        boolean air2 = world.getBlockState(pos.up(2)).getMaterial().isReplaceable();
        return base && air1 && air2;
    }

    public DimensionType getDimensionType() {
        return WitcheryDimensions.TORMENT.getType();
    }

    public IChunkGenerator createChunkGenerator() {
        return new ChunkGeneratorTorment(this.world);
    }

    public boolean canRespawnHere() {
        return false;
    }

    public boolean isSurfaceWorld() {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return false;
    }

    public boolean isDaytime() {
        return false;
    }

    public BlockPos getSpawnPoint() {
        return new BlockPos(8, 14, 8);
    }

    public boolean isSkyColored() {
        return true;
    }

    public float calculateCelestialAngle(long par1, float par3) {
        return 1.0f;
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return new Vec3d(1.0, 0.0, 0.0);
    }
}

