/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.dimension.spirit;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.block.BlockDreamWeaver;
import net.msrandom.witchery.block.BlockFetish;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityNightmare;
import net.msrandom.witchery.entity.EntitySleepingBody;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.items.WitcheryBrewItems;
import net.msrandom.witchery.init.items.WitcheryFumeItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.network.PacketPlayerStyle;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.world.dimension.spirit.SpiritWorldData;

public class WorldProviderSpiritWorld
extends WorldProvider {
    public WorldProviderSpiritWorld() {
        if (WitcheryResurrected.isClient()) {
            this.setCloudRenderer(new IRenderHandler(){

                public void render(float partialTicks, WorldClient world, Minecraft mc) {
                }
            });
        }
    }

    private static void addItemToInventory(EntityPlayer player, ItemStack protoStack, int totalQuantity) {
        if (totalQuantity > 0) {
            int quantity;
            int maxStack = protoStack.getMaxStackSize();
            for (int itemsRemaining = totalQuantity; itemsRemaining > 0; itemsRemaining -= quantity) {
                quantity = Math.min(itemsRemaining, maxStack);
                ItemStack newStack = new ItemStack(protoStack.getItem(), quantity, protoStack.getItemDamage());
                player.inventory.addItemStackToInventory(newStack);
            }
        }
    }

    private static void addItemToInventory(EntityPlayer player, ArrayList<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (player.inventory.addItemStackToInventory(stack)) continue;
            player.world.spawnEntity((Entity)new EntityItem(player.world, player.posX, 0.5 + player.posY, player.posZ, stack));
        }
    }

    public static void sendPlayerToSpiritWorld(EntityPlayer player, double nightmareChance) {
        if (player != null && !player.world.isRemote) {
            boolean demonic;
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            spiritData2.setBodyPosition(player.getPosition());
            int fireFound = 0;
            int heartsFound = 0;
            int spiritPoolFound = 0;
            int cottonFound = 0;
            boolean nightmareCatcherFound = false;
            double modifiedNightmareChance = nightmareChance;
            if (nightmareChance > 0.0 && nightmareChance < 1.0) {
                int R = 8;
                int posX = MathHelper.floor((double)player.posX);
                int posY = MathHelper.floor((double)player.posY);
                int posZ = MathHelper.floor((double)player.posZ);
                for (int x = posX - R; x <= posX + R; ++x) {
                    for (int z = posZ - R; z <= posZ + R; ++z) {
                        for (int y = posY - R; y <= posY + R; ++y) {
                            BlockPos pos = new BlockPos(x, y, z);
                            IBlockState state = player.world.getBlockState(pos);
                            Block block = state.getBlock();
                            if (!nightmareCatcherFound && block instanceof BlockDreamWeaver && ((BlockDreamWeaver)block).getModifier() == BlockDreamWeaver.Modifier.CAUSES_NIGHTMARES) {
                                modifiedNightmareChance -= 0.5;
                                nightmareCatcherFound = true;
                            }
                            if (spiritPoolFound < 3 && block == WitcheryBlocks.FLOWING_SPIRIT && (Integer)state.getValue((IProperty)BlockFluidBase.LEVEL) == 0) {
                                ++spiritPoolFound;
                                modifiedNightmareChance -= 0.1;
                            }
                            if (cottonFound < 2 && block == WitcheryBlocks.WISPY_COTTON) {
                                ++cottonFound;
                                modifiedNightmareChance -= 0.1;
                            }
                            if (heartsFound < 2 && block == WitcheryBlocks.DEMON_HEART) {
                                ++heartsFound;
                                modifiedNightmareChance += 0.35;
                            }
                            if (fireFound >= 3 || block != Blocks.FIRE) continue;
                            ++fireFound;
                            modifiedNightmareChance += 0.1;
                        }
                    }
                }
                modifiedNightmareChance = nightmareCatcherFound ? Math.min(Math.max(modifiedNightmareChance, 0.0), 1.0) : nightmareChance;
            }
            boolean nightmare = modifiedNightmareChance != 0.0 && (modifiedNightmareChance == 1.0 || player.world.rand.nextDouble() < modifiedNightmareChance);
            boolean bl = demonic = nightmare && nightmareCatcherFound && spiritPoolFound > 0 && heartsFound > 0 && player.world.rand.nextDouble() < (double)heartsFound * 0.35 + (double)fireFound * 0.1;
            SpiritWorldData.NightmareLevel level = nightmare ? (demonic ? SpiritWorldData.NightmareLevel.DEMONIC : SpiritWorldData.NightmareLevel.NIGHTMARE) : SpiritWorldData.NightmareLevel.DREAM;
            spiritData2.setNightmareLevel(level);
            spiritData2.setSpiritWalking(true);
            EntitySleepingBody corpse = new EntitySleepingBody(player.world);
            corpse.setHealth(player.getHealth());
            corpse.setCustomNameTag(player.getName());
            corpse.setOwner(player);
            corpse.setLocationAndAngles(0.5 + (double)MathHelper.floor((double)player.posX), player.posY, 0.5 + (double)MathHelper.floor((double)player.posZ), player.rotationPitch, 0.0f);
            player.world.spawnEntity((Entity)corpse);
            spiritData2.setOriginalDimension(player.world.provider.getDimensionType());
            int boneNeedles = player.inventory.clearMatchingItems(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            int mutandis = player.inventory.clearMatchingItems(WitcheryIngredientItems.MUTANDIS, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            NBTTagList originalInventory = new NBTTagList();
            player.inventory.writeToNBT(originalInventory);
            spiritData2.getOriginalData().setInventory(originalInventory);
            boolean hasSpiritData2 = spiritData2.getHasSpiritData();
            if (hasSpiritData2) {
                player.inventory.readFromNBT(spiritData2.getSpiritData().getInventory());
            } else {
                player.inventory.clearMatchingItems(null, -1, -1, null);
            }
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.MUTANDIS), mutandis);
            spiritData2.getOriginalData().setHealth(Math.max(player.getHealth(), 1.0f));
            if (hasSpiritData2) {
                player.setHealth(Math.max(spiritData2.getSpiritData().getHealth(), 10.0f));
            } else {
                player.setHealth(player.getMaxHealth());
            }
            NBTTagCompound originalHunger = new NBTTagCompound();
            player.getFoodStats().writeNBT(originalHunger);
            spiritData2.getOriginalData().setHunger(originalHunger);
            if (hasSpiritData2) {
                player.getFoodStats().readNBT(spiritData2.getSpiritData().getHunger());
                player.getFoodStats().addStats(16, 0.8f);
            } else {
                player.getFoodStats().addStats(20 - player.getFoodStats().getFoodLevel(), 5.0f - player.getFoodStats().getSaturationLevel());
                player.getFoodStats().prevFoodLevel = 20;
            }
            WorldProviderSpiritWorld.changeDimension(player, WitcheryDimensions.SPIRIT_WORLD.getType());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(0.0, 0.1, 0.0), (EntityPlayerMP)player);
        }
    }

    public static void changeDimension(EntityPlayer player, DimensionType dimension) {
        WorldProviderSpiritWorld.dismount(player);
        WitcheryIngredientItem.travelToDimension(player, dimension.getId());
    }

    private static void dismount(EntityPlayer player) {
        if (player.isRiding()) {
            player.dismountRidingEntity();
        }
    }

    public static void findTopAndSetPosition(World world, EntityPlayer player) {
        WorldProviderSpiritWorld.findTopAndSetPosition(world, player, player.getPosition());
    }

    private static void findTopAndSetPosition(World world, EntityPlayer player, BlockPos pos) {
        if (!WorldProviderSpiritWorld.isValidSpawnPoint(world, pos)) {
            for (int i = 1; i <= 256; ++i) {
                if (pos.getY() + i < 256 && WorldProviderSpiritWorld.isValidSpawnPoint(world, pos.up(i))) {
                    pos = pos.up(i);
                    break;
                }
                if (pos.getY() - i > 2 && WorldProviderSpiritWorld.isValidSpawnPoint(world, pos.down(i))) {
                    pos = pos.down(i);
                    break;
                }
                if (pos.getY() - i <= 2 && pos.getY() + i >= 255) break;
            }
        }
        player.setPositionAndUpdate((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
    }

    private static boolean isValidSpawnPoint(World world, BlockPos pos) {
        Material materialBelow = world.getBlockState(pos.down()).getMaterial();
        return !world.isAirBlock(pos.down()) && materialBelow != Material.LAVA && world.isAirBlock(pos) && world.isAirBlock(pos.up());
    }

    public static void returnPlayerToOverworld(EntityPlayer player) {
        if (player != null && !player.world.isRemote) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            boolean isSpiritWorld = WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player);
            int cottonRemoved = isSpiritWorld ? player.inventory.clearMatchingItems(Item.getItemFromBlock((Block)WitcheryBlocks.WISPY_COTTON), 0, -1, null) : 0;
            int disturbed_cottonRemoved = isSpiritWorld ? player.inventory.clearMatchingItems(WitcheryIngredientItems.DISTURBED_COTTON, 0, -1, null) : 0;
            int hunger = isSpiritWorld ? player.inventory.clearMatchingItems(WitcheryFumeItems.MELLIFLUOUS_HUNGER, 0, -1, null) : 0;
            int spirit = isSpiritWorld ? player.inventory.clearMatchingItems((Item)WitcheryBrewItems.FLOWING_SPIRIT_BREW, 0, -1, null) : 0;
            int subduedSpirits = player.inventory.clearMatchingItems(WitcheryIngredientItems.SUBDUED_SPIRIT, 0, -1, null);
            int boneNeedles = player.inventory.clearMatchingItems(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player)) {
                NBTTagList spiritInventory = new NBTTagList();
                player.inventory.writeToNBT(spiritInventory);
                spiritData2.getSpiritData().setInventory(spiritInventory);
            }
            player.inventory.readFromNBT(spiritData2.getOriginalData().getInventory());
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack((Block)WitcheryBlocks.WISPY_COTTON), cottonRemoved);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.DISTURBED_COTTON), disturbed_cottonRemoved);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryFumeItems.MELLIFLUOUS_HUNGER), hunger);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack((Item)WitcheryBrewItems.FLOWING_SPIRIT_BREW), spirit);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.SUBDUED_SPIRIT), subduedSpirits);
            spiritData2.getSpiritData().setHealth(Math.max(player.getHealth(), 10.0f));
            player.setHealth(spiritData2.getOriginalData().getHealth());
            NBTTagCompound spiritHunger = new NBTTagCompound();
            player.getFoodStats().writeNBT(spiritHunger);
            spiritData2.getSpiritData().setHunger(spiritHunger);
            player.getFoodStats().readNBT(spiritData2.getOriginalData().getHunger());
            spiritData2.setNightmareLevel(SpiritWorldData.NightmareLevel.DREAM);
            spiritData2.setGhost(false);
            spiritData2.setSpiritWalking(false);
            player.extinguish();
            BlockPos posBody = spiritData2.getBodyPosition();
            if (player.dimension != spiritData2.getOriginalDimension().getId()) {
                WorldProviderSpiritWorld.dismount(player);
                if (posBody != null) {
                    player.setPositionAndUpdate((double)posBody.getX(), (double)posBody.getY(), (double)posBody.getZ());
                }
                WitcheryIngredientItem.travelToDimension(player, spiritData2.getOriginalDimension().getId());
            }
            if (posBody != null) {
                WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player, posBody);
                spiritData2.setBodyPosition(null);
            } else {
                WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
            }
            for (Entity entity : player.world.loadedEntityList) {
                EntitySleepingBody corpse;
                if (!(entity instanceof EntitySleepingBody) || player != (corpse = (EntitySleepingBody)entity).getOwner()) continue;
                player.world.removeEntity((Entity)corpse);
            }
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(0.0, 0.1, 0.0), (EntityPlayerMP)player);
        }
    }

    public static void manifestPlayerInOverworldAsGhost(EntityPlayer player) {
        if (player != null && !player.world.isRemote) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            int boneNeedles = player.inventory.clearMatchingItems(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            IntegrationManager.dropPlayerBackpack(player);
            NBTTagList spiritInventory = new NBTTagList();
            player.inventory.writeToNBT(spiritInventory);
            spiritData2.getSpiritData().setInventory(spiritInventory);
            player.inventory.clearMatchingItems(null, -1, -1, null);
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            spiritData2.getSpiritData().setHealth(Math.max(player.getHealth(), 1.0f));
            spiritData2.setGhost(true);
            WorldProviderSpiritWorld.dismount(player);
            WitcheryIngredientItem.travelToDimension(player, spiritData2.getOriginalDimension().getId());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
        }
    }

    public static void returnGhostPlayerToSpiritWorld(EntityPlayer player) {
        if (player != null && !player.world.isRemote) {
            int boneNeedles = player.inventory.clearMatchingItems(WitcheryIngredientItems.ICY_NEEDLE, 0, -1, null);
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            ArrayList<ItemStack> fetishes = WorldProviderSpiritWorld.getBoundFetishes(player.inventory);
            player.inventory.dropAllItems();
            IntegrationManager.dropPlayerBackpack(player);
            player.inventory.readFromNBT(spiritData2.getSpiritData().getInventory());
            WorldProviderSpiritWorld.addItemToInventory(player, new ItemStack(WitcheryIngredientItems.ICY_NEEDLE), boneNeedles);
            WorldProviderSpiritWorld.addItemToInventory(player, fetishes);
            spiritData2.setGhost(false);
            WorldProviderSpiritWorld.changeDimension(player, WitcheryDimensions.SPIRIT_WORLD.getType());
            WorldProviderSpiritWorld.findTopAndSetPosition(player.world, player);
            WitcheryNetworkChannel.sendToAll(new PacketPlayerStyle(player));
        }
    }

    private static ArrayList<ItemStack> getBoundFetishes(InventoryPlayer inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty() || !(Block.getBlockFromItem((Item)stack.getItem()) instanceof BlockFetish) || !stack.hasTagCompound() || !WitcheryUtils.getOrCreateTag(stack).hasKey("SpiritEffect")) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static void updatePlayerEffects(World world, EntityPlayer player, long counter) {
        if (!world.isRemote) {
            SpiritWorldData spiritData2 = WitcheryUtils.getExtension(player).getSpiritData();
            if (counter % 20L == 0L && spiritData2.getMustWakeUp()) {
                spiritData2.setMustWakeUp(false);
                if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && spiritData2.isSpiritWalking() && !spiritData2.isGhost()) {
                    WorldProviderSpiritWorld.returnPlayerToOverworld(player);
                } else if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player)) {
                    WorldProviderSpiritWorld.returnPlayerToOverworld(player);
                }
            }
            if (counter % 100L == 0L) {
                SpiritWorldData.NightmareLevel nightmareLevel = spiritData2.getNightmareLevel();
                if (!player.capabilities.isCreativeMode && world.getDifficulty() != EnumDifficulty.PEACEFUL && WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && nightmareLevel != SpiritWorldData.NightmareLevel.DREAM) {
                    double R = 18.0;
                    double H = 18.0;
                    AxisAlignedBB bounds = new AxisAlignedBB(player.posX - R, player.posY - H, player.posZ - R, player.posX + R, player.posY + H, player.posZ + R);
                    if (nightmareLevel == SpiritWorldData.NightmareLevel.DEMONIC) {
                        List entities;
                        double chance = world.rand.nextDouble();
                        if (chance < 0.5) {
                            EntitySmallFireball fireball = new EntitySmallFireball(world, player.posX - 2.0 + (double)world.rand.nextInt(5), player.posY + 15.0, player.posZ - 2.0 + (double)world.rand.nextInt(5), 0.0, -0.2, 0.0);
                            world.spawnEntity((Entity)fireball);
                        } else if (chance < 0.65) {
                            EntityLargeFireball fireball2 = new EntityLargeFireball(world);
                            double par2 = player.posX - 2.0 + (double)world.rand.nextInt(5);
                            double par3 = player.posY + 15.0;
                            double par4 = player.posZ - 2.0 + (double)world.rand.nextInt(5);
                            double par5 = 0.0;
                            double par6 = -0.2;
                            double par7 = 0.0;
                            fireball2.setLocationAndAngles(par2, par3, par4, fireball2.rotationYaw, fireball2.rotationPitch);
                            fireball2.setPosition(par2, par3, par4);
                            double d6 = MathHelper.sqrt((double)(par5 * par5 + par6 * par6 + par7 * par7));
                            fireball2.accelerationX = par5 / d6 * 0.1;
                            fireball2.accelerationY = par6 / d6 * 0.1;
                            fireball2.accelerationZ = par7 / d6 * 0.1;
                            world.spawnEntity((Entity)fireball2);
                        } else if (chance < 0.75 && (entities = world.getEntitiesWithinAABB(EntityMob.class, bounds)).size() < 10 && !WorldProviderSpiritWorld.containsDemons(entities)) {
                            Infusion.spawnCreature(world, EntityDemon.class, player.getPosition(), (EntityLivingBase)player, 4, 8, EnumParticleTypes.SMOKE_NORMAL, SoundEvents.ENTITY_WITHER_DEATH);
                        }
                    }
                    List entities2 = world.getEntitiesWithinAABB(EntityNightmare.class, bounds);
                    for (EntityNightmare nightmare : entities2) {
                        if (!player.getUniqueID().equals(nightmare.getVictimId())) continue;
                        return;
                    }
                    long currentTime = world.getTotalWorldTime();
                    long lastKillTime = spiritData2.getLastNightmareKill();
                    if (lastKillTime < currentTime - 600L) {
                        Infusion.spawnCreature(world, EntityNightmare.class, player.getPosition(), player, 2, 6);
                    }
                } else if (!WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)player) && spiritData2.isGhost()) {
                    boolean skipNext = spiritData2.getSkipManifestation();
                    int timeRemaining = spiritData2.getManifestationDuration();
                    if (timeRemaining > 0 && ((timeRemaining = Math.max(0, timeRemaining - 5)) >= 60 && timeRemaining <= 64 || timeRemaining >= 30 && timeRemaining <= 34 || timeRemaining >= 15 && timeRemaining <= 19) && !skipNext) {
                        player.sendMessage(new TextComponentTranslation("rite.witchery.manifestation.countdown", new Object[]{timeRemaining}).setStyle(new Style().setColor(TextFormatting.LIGHT_PURPLE)));
                    }
                    if (timeRemaining == 0) {
                        WorldProviderSpiritWorld.returnGhostPlayerToSpiritWorld(player);
                    } else if (!skipNext) {
                        spiritData2.setManifestationDuration(timeRemaining);
                    } else {
                        spiritData2.setSkipManifestation(false);
                    }
                }
            }
        }
    }

    private static boolean containsDemons(List<EntityMob> entities) {
        int count = 0;
        for (EntityCreature entityCreature : entities) {
            if (!(entityCreature instanceof EntityDemon) || ++count < 2) continue;
            return true;
        }
        return false;
    }

    public DimensionType getDimensionType() {
        return WitcheryDimensions.SPIRIT_WORLD.getType();
    }

    public float getStarBrightness(float par1) {
        return 0.0f;
    }

    public boolean canRespawnHere() {
        return false;
    }

    public double getMovementFactor() {
        return 1.0;
    }

    public float calculateCelestialAngle(long par1, float par3) {
        return WitcheryUtils.getNightmareLevel(this.world) == SpiritWorldData.NightmareLevel.DREAM ? 1.0f : 0.5f;
    }

    public float getCloudHeight() {
        return 0.0f;
    }

    public boolean canCoordinateBeSpawn(int par1, int par2) {
        int var3 = this.world.getTopSolidOrLiquidBlock(new BlockPos(par1, 0, par2)).getY();
        return var3 != -1;
    }

    public BlockPos getSpawnCoordinate() {
        return new BlockPos(100, 50, 0);
    }

    public int getAverageGroundLevel() {
        return 64;
    }

    public double getHorizon() {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return true;
    }

    public double getVoidFogYFactor() {
        return 1.0;
    }

    public Vec3d getFogColor(float celestialAngle, float partialTicks) {
        float angle = MathHelper.cos((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (angle < 0.0f) {
            angle = 0.0f;
        }
        if (angle > 1.0f) {
            angle = 1.0f;
        }
        switch (WitcheryUtils.getNightmareLevel(this.world)) {
            case DREAM: {
                float red = 0.8f;
                float green = 0.2f;
                float blue = 0.6f;
                break;
            }
            case NIGHTMARE: {
                float red = 0.0f;
                float green = 1.0f;
                float blue = 0.0f;
                break;
            }
            default: {
                float red = 1.0f;
                float green = 0.0f;
                float blue = 0.0f;
            }
        }
        return new Vec3d((double)(red *= angle * 0.94f + 0.06f), (double)(green *= angle * 0.94f + 0.06f), (double)(blue *= angle * 0.91f + 0.09f));
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
    }
}

