/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world.dimension;

import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.world.gen.ChunkGeneratorMirror;

public class WorldProviderMirror
extends WorldProvider {
    public WorldProviderMirror() {
        this.hasSkyLight = false;
    }

    public int getActualHeight() {
        return WitcheryConfigOptions.shrinkMirrorWorld ? this.getHeight() : super.getActualHeight();
    }

    public DimensionType getDimensionType() {
        return WitcheryDimensions.MIRROR.getType();
    }

    public IChunkGenerator createChunkGenerator() {
        return new ChunkGeneratorMirror(this.world);
    }

    public boolean canRespawnHere() {
        return false;
    }

    public boolean isSurfaceWorld() {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean isBlockHighHumidity(BlockPos pos) {
        return false;
    }

    public boolean isDaytime() {
        return false;
    }

    public BlockPos getSpawnPoint() {
        return new BlockPos(4, 9, 4);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSkyColored() {
        return false;
    }

    protected void generateLightBrightnessTable() {
        float f = 0.1f;
        for (int i = 0; i <= 15; ++i) {
            float f2 = 1.0f - (float)i / 15.0f;
            this.lightBrightnessTable[i] = (1.0f - f2) / (f2 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
    }

    public Vec3d getFogColor(float p_76562_1_, float p_76562_2_) {
        return new Vec3d(0.0, 0.03, 0.1);
    }

    public boolean doesXZShowFog(int p_76568_1_, int p_76568_2_) {
        return true;
    }

    public float calculateCelestialAngle(long par1, float par3) {
        return 0.5f;
    }

    public float getSunBrightnessFactor(float par1) {
        return 0.0f;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }
}

