/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.world;

import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.world.gen.structure.ComponentVillageKeep;
import net.msrandom.witchery.world.gen.structure.ComponentVillageWall;
import net.msrandom.witchery.world.gen.structure.ComponentVillageWatchTower;

public class WorldHandlerVillageDistrict
implements VillagerRegistry.IVillageCreationHandler {
    private final Class<? extends StructureVillagePieces.Village> pieceClazz;
    private final int weight;
    private final int quantityMin;
    private final int quantityMax;

    public WorldHandlerVillageDistrict(Class<? extends StructureVillagePieces.Village> clazz, int weight, int min, int max) {
        this.pieceClazz = clazz;
        this.weight = weight;
        this.quantityMin = min;
        this.quantityMax = max;
    }

    public static void registerComponent(Class<? extends StructureVillagePieces.Village> clazz, int weight, int min, int max) {
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WorldHandlerVillageDistrict(clazz, weight, min, max));
    }

    public static void init() {
        MapGenStructureIO.registerStructureComponent(ComponentVillageWall.class, (String)"witchery:villagewall");
        MapGenStructureIO.registerStructureComponent(ComponentVillageKeep.class, (String)"witchery:villagekeep");
        MapGenStructureIO.registerStructureComponent(ComponentVillageWatchTower.class, (String)"witchery:villagewatchtower");
        if (WitcheryConfigOptions.townWallChance > 0) {
            WorldHandlerVillageDistrict.registerComponent(ComponentVillageWall.class, WitcheryConfigOptions.townWallWeight, WitcheryConfigOptions.townWallChance == 2 ? 1 : 0, 1);
        }
        if (WitcheryConfigOptions.townKeepChance > 0) {
            WorldHandlerVillageDistrict.registerComponent(ComponentVillageKeep.class, WitcheryConfigOptions.townKeepWeight, WitcheryConfigOptions.townKeepChance == 2 ? 1 : 0, 1);
        }
        VillagerRegistry register2 = VillagerRegistry.instance();
        for (WitcheryConfigOptions.Building building : WitcheryConfigOptions.townParts) {
            for (int i = 0; i < building.getGroups(); ++i) {
                register2.registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new WorldHandlerVillageDistrict(building.clazz, building.getWeight(), building.getMin(), building.getMax()));
            }
        }
        for (Biome biome : ForgeRegistries.BIOMES) {
            boolean disallowed;
            if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || (disallowed = !WitcheryConfigOptions.townAllowSandy && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY) || !WitcheryConfigOptions.townAllowPlains && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || !WitcheryConfigOptions.townAllowMountain && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || !WitcheryConfigOptions.townAllowHills && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS) || !WitcheryConfigOptions.townAllowForest && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || !WitcheryConfigOptions.townAllowSnowy && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) || !WitcheryConfigOptions.townAllowJungle && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE) || !WitcheryConfigOptions.townAllowMesa && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA))) continue;
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random rand, int size) {
        return new StructureVillagePieces.PieceWeight(this.pieceClazz, this.weight, this.quantityMax <= this.quantityMin ? this.quantityMin : this.quantityMin + rand.nextInt(this.quantityMax - this.quantityMin + 1));
    }

    public Class<? extends StructureComponent> getComponentClass() {
        return this.pieceClazz;
    }

    public StructureVillagePieces.Village buildComponent(StructureVillagePieces.PieceWeight weight, StructureVillagePieces.Start startPiece, List<StructureComponent> pieces, Random rand, int p1, int p2, int p3, EnumFacing p4, int p5) {
        Object object = null;
        if (this.pieceClazz == StructureVillagePieces.House4Garden.class) {
            object = StructureVillagePieces.House4Garden.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.Church.class) {
            object = StructureVillagePieces.Church.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.House1.class) {
            object = StructureVillagePieces.House1.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.WoodHut.class) {
            object = StructureVillagePieces.WoodHut.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.Hall.class) {
            object = StructureVillagePieces.Hall.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.Field1.class) {
            object = StructureVillagePieces.Field1.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.Field2.class) {
            object = StructureVillagePieces.Field2.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.House2.class) {
            object = StructureVillagePieces.House2.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == StructureVillagePieces.House3.class) {
            object = StructureVillagePieces.House3.createPiece((StructureVillagePieces.Start)startPiece, pieces, (Random)rand, (int)p1, (int)p2, (int)p3, (EnumFacing)p4, (int)p5);
        } else if (this.pieceClazz == ComponentVillageWall.class) {
            object = ComponentVillageWall.createPiece(startPiece, pieces, p1, p2, p3, p4, p5);
        } else if (this.pieceClazz == ComponentVillageWatchTower.class) {
            object = ComponentVillageWatchTower.createPiece(startPiece, pieces, p1, p2, p3, p4, p5);
        } else if (this.pieceClazz == ComponentVillageKeep.class) {
            object = ComponentVillageKeep.createPiece(startPiece, pieces, p1, p2, p3, p4, p5);
        }
        return object;
    }
}

