/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.item.ItemTaglockKit;

public class Waypoint {
    public final boolean valid;
    public final double X;
    public final double Y;
    public final double Z;
    public final double D;

    public Waypoint(World world, ItemStack stack, double homeX, double homeY, double homeZ) {
        if (stack.getItem() == WitcheryIngredientItems.BOUND_WAYSTONE) {
            int z;
            NBTTagCompound nbtWaystone = stack.getTagCompound();
            int x = nbtWaystone.getInteger("X");
            if (world.getChunk(new BlockPos(x, 0, z = nbtWaystone.getInteger("Z"))).isLoaded()) {
                this.X = (double)x + 0.5;
                this.Y = (double)nbtWaystone.getInteger("Y") + 1.5;
                this.Z = (double)z + 0.5;
                this.D = nbtWaystone.getInteger("Dimension");
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.getDimension();
                this.valid = false;
            }
        } else if (stack.getItem() == WitcheryIngredientItems.PLAYER_BOUND_WAYSTONE) {
            EntityLivingBase entity = ItemTaglockKit.getBoundEntity(world, stack, 0);
            if (entity != null) {
                this.X = entity.posX;
                this.Y = entity.posY + 1.0;
                this.Z = entity.posZ;
                this.D = entity.dimension;
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.getDimension();
                this.valid = false;
            }
        } else if (stack.getItem() == WitcheryGeneralItems.BOUND_TAGLOCK_KIT) {
            EntityLivingBase entity = ItemTaglockKit.getBoundEntity(world, stack, 0);
            if (entity != null) {
                this.X = entity.posX;
                this.Y = entity.posY + 1.0;
                this.Z = entity.posZ;
                this.D = entity.dimension;
                this.valid = true;
            } else {
                this.X = homeX;
                this.Y = homeY;
                this.Z = homeZ;
                this.D = world.provider.getDimension();
                this.valid = false;
            }
        } else {
            this.X = homeX;
            this.Y = homeY;
            this.Z = homeZ;
            this.D = world.provider.getDimension();
            this.valid = false;
        }
    }
}

