/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class MutableBlock
extends WeightedRandom.Item {
    @Nullable
    private final IBlockState state;
    private final IBlockState newState;

    public MutableBlock(IBlockState state) {
        this(state, state.getBlock().getDefaultState());
    }

    public MutableBlock(IBlockState state, IBlockState newState) {
        this(state, newState, 1);
    }

    public MutableBlock(IBlockState state, int weight) {
        this(state, state.getBlock().getDefaultState(), weight);
    }

    public MutableBlock(@Nullable IBlockState state, IBlockState newState, int weight) {
        super(weight);
        this.state = state;
        this.newState = newState;
    }

    public int hashCode() {
        return this.newState.getBlock().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MutableBlock other = (MutableBlock)((Object)obj);
        return this.newState.getBlock() == other.newState.getBlock() && (this.state == null || other.state == null || this.state == other.state);
    }

    public void mutate(World world, BlockPos pos) {
        this.mutate(world, pos, true);
    }

    public void mutate(World world, BlockPos pos, boolean allowAnyPlacement) {
        if (this.state != null) {
            if (allowAnyPlacement || this.newState.getBlock().canPlaceBlockAt(world, pos)) {
                world.setBlockState(pos, this.state, 3);
            }
        } else if (this.newState != this.newState.getBlock().getDefaultState()) {
            if (allowAnyPlacement || this.newState.getBlock().canPlaceBlockAt(world, pos)) {
                world.setBlockState(pos, this.newState, 3);
            }
        } else if (allowAnyPlacement || this.newState.getBlock().canPlaceBlockAt(world, pos)) {
            world.setBlockState(pos, this.newState.getBlock().getDefaultState());
        }
    }
}

