/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.msrandom.witchery.entity.ai.EntityAIAttackOnCollide;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.network.PacketPushTarget;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.util.BlockUtil;
import net.msrandom.witchery.util.IHandleDeathTouch;

public class EntityUtil {
    private EntityUtil() {
    }

    public static EntityPlayer playerOrFake(World world, EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        if (!(world instanceof WorldServer)) {
            return null;
        }
        return FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
    }

    public static void pullTowards(Entity entity, Vec3d target, double dy, double yy) {
        if (entity instanceof EntityDragon || entity instanceof EntityHornedHuntsman || entity.getPositionVector().equals((Object)target)) {
            return;
        }
        double d = target.x - entity.posX;
        double d2 = target.y - entity.posY;
        double d3 = target.z - entity.posZ;
        float distance = MathHelper.sqrt((double)(d * d + d2 * d2 + d3 * d3));
        if ((double)distance < 0.01) {
            return;
        }
        float f2 = 0.1f + (float)dy;
        double mx = d / (double)distance * (double)f2 * (double)distance;
        double my = yy == 0.0 ? 0.4 : d2 / (double)distance * (double)distance * 0.2 + 0.2 + yy;
        double mz = d3 / (double)distance * (double)f2 * (double)distance;
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(MobEffects.JUMP_BOOST, 20, 1));
        }
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(mx, my, mz), (EntityPlayerMP)entity);
        } else {
            entity.motionX = mx;
            entity.motionY = my;
            entity.motionZ = mz;
        }
    }

    public static void pushback(Entity entity, Vec3d hit, double xyScale, double ySpeed) {
        double d = hit.x - entity.posX;
        double d2 = hit.y - entity.posY;
        double d3 = hit.z - entity.posZ;
        Vec3d vec = new Vec3d(d, d2, d3).normalize();
        double dx = -vec.x * xyScale;
        double dy = Math.max(-vec.y, ySpeed);
        double dz = -vec.z * xyScale;
        if (entity instanceof EntityPlayerMP) {
            WitcheryNetworkChannel.sendTo(new PacketPushTarget(dx, dy, dz), (EntityPlayerMP)entity);
        } else {
            entity.motionX = dx;
            entity.motionY = dy;
            entity.motionZ = dz;
        }
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, TileEntity tile, double radius) {
        return EntityUtil.getEntitiesInRadius(clazz, tile.getWorld(), 0.5 + (double)tile.getPos().getX(), 0.5 + (double)tile.getPos().getY(), 0.5 + (double)tile.getPos().getZ(), radius);
    }

    public static <T extends Entity> List<T> getEntitiesInRadius(Class<T> clazz, World world, double x, double y, double z, double radius) {
        AxisAlignedBB bounds = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entities = world.getEntitiesWithinAABB(clazz, bounds);
        ArrayList<Entity> nearbyEntities = new ArrayList<Entity>();
        double radiusSq = radius * radius;
        for (Entity entity : entities) {
            if (!(entity.getDistanceSq(x, entity.posY, z) <= radiusSq)) continue;
            nearbyEntities.add(entity);
        }
        return nearbyEntities;
    }

    public static void setTarget(EntityLiving attacker, EntityLivingBase victim) {
        attacker.setAttackTarget(victim);
        if (attacker instanceof EntityCreature) {
            EntityCreature attackerCreature = (EntityCreature)attacker;
            attackerCreature.setRevengeTarget(victim);
            if (attackerCreature instanceof EntityZombie || attackerCreature instanceof EntityCreeper) {
                boolean found = false;
                Class<?> victimClass = victim.getClass();
                for (EntityAITasks.EntityAITaskEntry task : attackerCreature.targetTasks.taskEntries) {
                    if (!(task.action instanceof EntityAIAttackOnCollide)) continue;
                    EntityAIAttackOnCollide ai = (EntityAIAttackOnCollide)task.action;
                    if (!ai.appliesToClass(victimClass)) break;
                    found = true;
                    break;
                }
                if (!found) {
                    attacker.tasks.addTask(2, new EntityAIAttackOnCollide(attackerCreature, victimClass, false));
                }
            }
        }
    }

    public static void dropAttackTarget(EntityLiving entity) {
        entity.setAttackTarget(null);
        if (entity instanceof EntityCreature) {
            EntityCreature creatureEntity = (EntityCreature)entity;
            creatureEntity.setRevengeTarget(null);
        }
    }

    public static float getHealthAfterDamage(LivingHurtEvent event, float currentHealth, EntityLivingBase entity) {
        float j;
        if (event.getSource().isUnblockable()) {
            return currentHealth - event.getAmount();
        }
        float damage = event.getAmount();
        int i = 25 - entity.getTotalArmorValue();
        float f1 = damage * (float)i;
        damage = f1 / 25.0f;
        if (entity.isPotionActive(MobEffects.RESISTANCE) && event.getSource() != DamageSource.OUT_OF_WORLD) {
            i = (entity.getActivePotionEffect(MobEffects.RESISTANCE).getAmplifier() + 1) * 5;
            j = 25 - i;
            f1 = damage * j;
            damage = f1 / 25.0f;
        }
        if (damage <= 0.0f) {
            damage = 0.0f;
        } else {
            i = EnchantmentHelper.getEnchantmentModifierDamage(Collections.singleton(entity.getActiveItemStack()), (DamageSource)event.getSource());
            if (i > 20) {
                i = 20;
            }
            if (i > 0) {
                j = 25 - i;
                f1 = damage * j;
                damage = f1 / 25.0f;
            }
        }
        return currentHealth - damage;
    }

    public static void sunDeath(EntityPlayer player) {
        if (player != null && !player.world.isRemote && !player.capabilities.isCreativeMode) {
            if (player.isPlayerSleeping()) {
                player.wakeUpPlayer(true, true, false);
            }
            player.attackEntityFrom((DamageSource)DamageSourceSunlight.SUN, Float.MAX_VALUE);
            player.setHealth(0.0f);
        }
    }

    public static void instantDeath(EntityLivingBase entity, EntityLivingBase attacker, Entity directDamage) {
        if (entity != null && !entity.world.isRemote) {
            DamageSource magic = attacker == null ? DamageSource.MAGIC : (directDamage == null ? DamageSource.causeIndirectMagicDamage((Entity)attacker, null) : DamageSource.causeIndirectMagicDamage((Entity)directDamage, (Entity)attacker));
            if (entity instanceof EntityLiving) {
                entity.attackEntityFrom(magic, Float.MAX_VALUE);
                entity.setHealth(0.0f);
            } else if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.capabilities.isCreativeMode) {
                    if (player.isPlayerSleeping()) {
                        player.wakeUpPlayer(true, true, false);
                    }
                    entity.attackEntityFrom(magic, Float.MAX_VALUE);
                    entity.setHealth(0.0f);
                }
            }
        }
    }

    public static boolean touchOfDeath(Entity victim, EntityLivingBase attacker, float damage) {
        if (victim != null && victim.getIsInvulnerable()) {
            return false;
        }
        if (victim != null && victim.world != null && !victim.world.isRemote) {
            DamageSource magic;
            DamageSource damageSource = magic = attacker == null ? DamageSource.MAGIC : DamageSource.causeIndirectMagicDamage((Entity)attacker, null);
            if (victim instanceof EntityLiving) {
                EntityLiving creature = (EntityLiving)victim;
                float cap = 10000.0f;
                if (victim instanceof IHandleDeathTouch) {
                    cap = ((IHandleDeathTouch)victim).getCapDT(magic);
                    if (cap <= 0.0f) {
                        return false;
                    }
                    if (attacker instanceof EntityLiving) {
                        cap = Math.min(6.0f, cap);
                    }
                }
                float newHealth = creature.getHealth() - Math.min(damage, cap);
                creature.setHealth(Math.max(newHealth, 0.0f));
                creature.attackEntityFrom(magic, newHealth <= 0.0f ? Float.MAX_VALUE : 0.0f);
            } else if (victim instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)victim;
                if (player.capabilities.isCreativeMode) {
                    return false;
                }
                float newHealth = player.getHealth() - damage;
                player.attackEntityFrom(magic, newHealth <= 0.0f ? Float.MAX_VALUE : 0.0f);
                player.setHealth(Math.max(newHealth, 0.0f));
            }
        }
        return true;
    }

    public static void moveToBlockPositionAndUpdate(EntityLiving entity, BlockPos pos, int maxDY) {
        World world = entity.world;
        boolean done = false;
        int mod = 0;
        int sign = -1;
        while (!done && mod <= 2 * maxDY && pos.getY() < 250 && pos.getY() > 2) {
            if (BlockUtil.isNormalCube(world.getBlockState(pos)) && world.isAirBlock(pos.up()) && world.isAirBlock(pos.up(2))) {
                done = true;
                continue;
            }
            pos = pos.up(++mod * (sign *= -1));
        }
        if (done) {
            entity.setPositionAndUpdate(0.5 + (double)pos.getX(), 1.05 + (double)pos.getY(), 0.5 + (double)pos.getZ());
        }
    }

    public static class DamageSourceVampireFire
    extends DamageSource {
        public static final DamageSourceVampireFire SOURCE = new DamageSourceVampireFire();

        public DamageSourceVampireFire() {
            super("onFire");
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }
    }

    public static class DamageSourceSunlight
    extends DamageSource {
        public static final DamageSourceSunlight SUN = new DamageSourceSunlight();

        public DamageSourceSunlight() {
            super("sun");
            this.setDamageBypassesArmor();
            this.setMagicDamage();
        }
    }
}

