/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.transformation.AlternateForm;
import net.msrandom.witchery.util.WitcheryUtils;

public class EntitySizeInfo {
    public final float defaultWidth;
    public final float defaultHeight;
    public final float eyeHeight;
    public final float stepSize;
    public final AlternateForm.Stats stats;

    public EntitySizeInfo(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            this.stats = AlternateFormStatManager.INSTANCE.getStats(WitcheryUtils.getExtension((EntityPlayer)entity).getEffectiveForm());
            this.defaultWidth = this.stats.getWidth();
            this.defaultHeight = this.stats.getHeight();
            this.stepSize = this.stats.getStepHeight();
            this.eyeHeight = this.stats.getEyeHeight();
        } else {
            NBTTagCompound nbtEntity = entity.getEntityData();
            this.stats = null;
            this.defaultWidth = nbtEntity.getFloat("WitcheryInitialWidth");
            this.defaultHeight = nbtEntity.getFloat("WitcheryInitialHeight");
            this.stepSize = entity instanceof EntityHorse || entity instanceof EntityEnderman ? 1.0f : 0.5f;
            this.eyeHeight = 0.12f;
        }
    }
}

