/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class EarthItems {
    private static final EarthItems INSTANCE = new EarthItems();

    public static EarthItems instance() {
        return INSTANCE;
    }

    public boolean isMatch(ItemStack itemstack) {
        Item item = itemstack.getItem();
        if (item instanceof ItemTool) {
            switch (((ItemTool)item).getToolMaterialName()) {
                case "IRON": 
                case "GOLD": {
                    return true;
                }
            }
            return false;
        }
        if (item instanceof ItemArmor) {
            switch (((ItemArmor)item).getArmorMaterial()) {
                case IRON: 
                case GOLD: 
                case CHAIN: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Item oreToIngot(Block block) {
        if (block == Blocks.IRON_ORE) {
            return Items.IRON_INGOT;
        }
        if (block == Blocks.GOLD_ORE) {
            return Items.GOLD_INGOT;
        }
        for (int oreID : OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            NonNullList ingotStacks;
            String oreName = OreDictionary.getOreName((int)oreID);
            if (!oreName.startsWith("ore")) continue;
            String ingotName = oreName.replace("ore", "ingot");
            String[] oreNames = OreDictionary.getOreNames();
            if (!Arrays.asList(oreNames).contains(ingotName) || (ingotStacks = OreDictionary.getOres((String)ingotName)).isEmpty()) continue;
            return ((ItemStack)ingotStacks.get(0)).getItem();
        }
        return null;
    }
}

