/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityBabaYaga;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.entity.EntityImp;
import net.msrandom.witchery.entity.EntityLeonard;
import net.msrandom.witchery.entity.EntityLordOfTorment;
import net.msrandom.witchery.entity.EntityReflection;
import net.msrandom.witchery.entity.EntityVampire;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.entity.item.EntityCrossbowBolt;
import net.msrandom.witchery.entity.monster.EntityHornedHuntsman;
import net.msrandom.witchery.entity.monster.EntityLilith;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.infusion.brew.InfusedBrewEffect;
import net.msrandom.witchery.init.WitcheryDimensions;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.infusions.WitcheryInfusedBrews;
import net.msrandom.witchery.init.items.WitcheryBoltItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.item.ItemVampireClothes;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.item.bolts.ItemCrossbowBolt;
import net.msrandom.witchery.resources.AlternateFormStatManager;
import net.msrandom.witchery.util.EntityUtil;
import net.msrandom.witchery.util.WitcheryUtils;
import net.msrandom.witchery.util.damage.EntityDamageSourceIndirectSilver;

public class CreatureUtil {
    private CreatureUtil() {
    }

    public static boolean isDemonic(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityDemon || entity instanceof EntityGhast || entity instanceof EntityBlaze || entity instanceof EntityMagmaCube || entity instanceof EntityLeonard || entity instanceof EntityLordOfTorment || entity instanceof EntityImp || entity instanceof EntityLilith || entity instanceof EntityWither) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                return false;
            }
            return IntegrationManager.isDemon(entity);
        }
        return false;
    }

    public static boolean isUndead(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityLiving) {
                EntityLiving living = (EntityLiving)entity;
                return living.isEntityUndead();
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                return playerEx.isTransformation(WitcheryTransformations.VAMPIRE) || InfusedBrewEffect.getActiveBrew(player) == WitcheryInfusedBrews.GRAVE;
            }
        }
        return false;
    }

    public static void spawnWithEgg(EntityLiving entity, boolean requirePersistance) {
        if (entity != null) {
            entity.onInitialSpawn(entity.world.getDifficultyForLocation(entity.getPosition()), null);
            if (requirePersistance) {
                entity.enablePersistence();
            }
        }
    }

    public static boolean isWitch(Entity entity) {
        if (entity != null) {
            if (entity instanceof EntityWitch || entity instanceof EntityBabaYaga) {
                return true;
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                for (int i = 0; i < player.inventory.mainInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)player.inventory.mainInventory.get(i);
                    Item item = stack.getItem();
                    if (item != WitcheryPoppetItems.VOODOO && item != WitcheryPoppetItems.VAMPIRIC) continue;
                    return true;
                }
                return Infusion.getInfusion(player).isValidForSpells();
            }
        }
        return false;
    }

    public static boolean isWoodenDamage(DamageSource source) {
        EntityCrossbowBolt bolt;
        if (source.getImmediateSource() != null && source.getImmediateSource() instanceof EntityLivingBase) {
            ItemSword sword;
            EntityLivingBase living = (EntityLivingBase)source.getImmediateSource();
            if (living instanceof EntityHornedHuntsman && !source.isProjectile()) {
                return true;
            }
            ItemStack stack = living.getHeldItemMainhand();
            if (stack.getItem() instanceof ItemSword ? (sword = (ItemSword)stack.getItem()).getToolMaterialName().equalsIgnoreCase(Item.ToolMaterial.WOOD.toString()) : stack.getItem() == WitcheryIngredientItems.STAKE || living.getHeldItemOffhand().getItem() == WitcheryIngredientItems.STAKE) {
                return true;
            }
        }
        if ((bolt = EntityCrossbowBolt.getSourceBolt(source)) != null) {
            Item item = bolt.getArrowStack().getItem();
            return ((ItemCrossbowBolt)item).isWooden();
        }
        return false;
    }

    public static boolean isSilverDamage(DamageSource source) {
        EntityLivingBase entity;
        ItemStack stack;
        if (source instanceof EntityDamageSourceIndirectSilver) {
            return true;
        }
        if (source.getImmediateSource() != null && source.getImmediateSource() instanceof EntityCrossbowBolt) {
            EntityCrossbowBolt bolt = (EntityCrossbowBolt)source.getImmediateSource();
            return bolt.getArrowStack().getItem() == WitcheryBoltItems.SILVER_BOLT;
        }
        if (!source.isProjectile() && source.getTrueSource() != null && source.getTrueSource() instanceof EntityLivingBase && !(stack = (entity = (EntityLivingBase)source.getTrueSource()).getHeldItemMainhand()).isEmpty() && stack.getItem() instanceof ItemSword) {
            return ((ItemSword)stack.getItem()).getToolMaterialName().contains("SILVER");
        }
        return false;
    }

    public static boolean isWerewolf(Entity entity) {
        return CreatureUtil.isWerewolf(entity, false);
    }

    public static boolean isWerewolf(Entity entity, boolean includeUnshifted) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityWerewolf) {
            return true;
        }
        if (entity instanceof EntityReflection) {
            return CreatureUtil.isWerewolf((Entity)((EntityReflection)entity).getReflected(), includeUnshifted);
        }
        if (entity instanceof EntityWereVillager) {
            return includeUnshifted;
        }
        if (entity instanceof EntityPlayer) {
            PlayerExtendedData playerEx = WitcheryUtils.getExtension((EntityPlayer)entity);
            return includeUnshifted && playerEx.isTransformation(WitcheryTransformations.WEREWOLF) || playerEx.getCurrentForm() != null && AlternateFormStatManager.INSTANCE.getStats(playerEx.getCurrentForm()).canHowl();
        }
        return WitcheryConfigOptions.werewolfEntities.contains(entity.getClass());
    }

    public static boolean isVampire(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityVampire) {
            return true;
        }
        if (entity instanceof EntityPlayer) {
            return WitcheryUtils.getExtension((EntityPlayer)entity).isTransformation(WitcheryTransformations.VAMPIRE);
        }
        if (entity instanceof EntityLiving) {
            String name2 = entity.getClass().getSimpleName();
            return name2.toUpperCase().contains("VAMPIRE");
        }
        return false;
    }

    public static boolean isFullMoon(World world) {
        return (double)world.getCurrentMoonPhaseFactor() == 1.0 && !world.isDaytime();
    }

    public static boolean isImmuneToDisease(EntityLivingBase livingEntity) {
        return CreatureUtil.isUndead((Entity)livingEntity) || CreatureUtil.isDemonic((Entity)livingEntity) || CreatureUtil.isWerewolf((Entity)livingEntity, true) || !livingEntity.isNonBoss() || livingEntity instanceof EntityGolem;
    }

    public static boolean isImmuneToPoison(EntityLivingBase livingEntity) {
        return CreatureUtil.isWerewolf((Entity)livingEntity, false);
    }

    public static boolean checkForVampireDeath(EntityLivingBase creature, DamageSource source) {
        boolean dead = false;
        if (source == DamageSource.OUT_OF_WORLD || source.isCreativePlayer()) {
            dead = true;
        } else if (source.isFireDamage() || source instanceof EntityUtil.DamageSourceVampireFire) {
            dead = ItemVampireClothes.isExtendedFlameProtectionActive(creature) ? creature.world.rand.nextInt(4) == 0 : !ItemVampireClothes.isFlameProtectionActive(creature) || creature.world.rand.nextInt(4) != 0;
        } else if (source instanceof EntityUtil.DamageSourceSunlight || source.damageType.equals("boil") || source.damageType.equals("stake")) {
            dead = true;
        } else if (creature instanceof EntityPlayer && IntegrationManager.canVampireBeKilled((EntityPlayer)creature)) {
            dead = true;
        } else if (source == DamageSource.IN_WALL) {
            dead = true;
        } else if (source.getTrueSource() != null && (CreatureUtil.isWerewolf(source.getTrueSource()) || CreatureUtil.isVampire(source.getTrueSource()) || !source.getTrueSource().isNonBoss())) {
            dead = true;
        } else if (CreatureUtil.isWerewolf((Entity)creature, true) && CreatureUtil.isSilverDamage(source)) {
            dead = true;
        }
        if (!dead) {
            creature.setHealth(1.0f);
            if (creature instanceof EntityPlayer) {
                ((EntityPlayer)creature).getFoodStats().addExhaustion(5.0f);
            }
            if (source.isExplosion() && creature.world.rand.nextInt(4) == 0) {
                creature.setFire(2);
            }
            return true;
        }
        return false;
    }

    public static boolean isInSunlight(EntityLivingBase entity) {
        int z;
        int y;
        World world = entity.world;
        if (WitcheryDimensions.SPIRIT_WORLD.isInDimension((Entity)entity) || WitcheryDimensions.TORMENT.isInDimension((Entity)entity) || !world.provider.hasSkyLight() || !world.provider.isSurfaceWorld() || !world.isDaytime()) {
            return false;
        }
        int x = MathHelper.floor((double)entity.posX);
        BlockPos pos = new BlockPos(x, y = MathHelper.floor((double)entity.posY), z = MathHelper.floor((double)entity.posZ));
        Biome biome = world.getBiomeForCoordsBody(pos);
        return !WitcheryConfigOptions.nightBiomes.contains(biome) && (!world.isRaining() || !biome.canRain()) && world.canSeeSky(pos.add(0, MathHelper.ceil((float)entity.height), 0));
    }
}

