/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.util.WitcheryUtils;

public class BlockUtil {
    public static void notifyBlockUpdate(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        world.notifyBlockUpdate(pos, state, state, 0);
    }

    public static IBlockState getBlock(World world, int posX, int posY, int posZ) {
        return world.getBlockState(new BlockPos(posX, posY, posZ));
    }

    public static IBlockState getBlock(World world, double posX, double posY, double posZ) {
        int x = MathHelper.floor((double)posX);
        int y = MathHelper.floor((double)posY);
        int z = MathHelper.floor((double)posZ);
        return BlockUtil.getBlock(world, x, y, z);
    }

    public static IBlockState getBlock(World world, RayTraceResult mop) {
        return BlockUtil.getBlock(world, mop, false);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ) {
        return BlockUtil.isReplaceableBlock(world, posX, posY, posZ, null);
    }

    public static boolean isReplaceableBlock(World world, int posX, int posY, int posZ, EntityLivingBase player) {
        return BlockUtil.isReplaceableBlock(world, new BlockPos(posX, posY, posZ), player);
    }

    public static boolean isReplaceableBlock(World world, BlockPos pos) {
        return BlockUtil.isReplaceableBlock(world, pos, null);
    }

    public static boolean isReplaceableBlock(World world, BlockPos pos, EntityLivingBase player) {
        IBlockState state = world.getBlockState(pos);
        if (player != null && !WitcheryUtils.isBlockBreakable(world, pos, state)) {
            return false;
        }
        return state.getMaterial().isReplaceable();
    }

    public static Material getBlockMaterial(EntityPlayer player) {
        return BlockUtil.getBlockMaterial(player, 0);
    }

    public static Material getBlockMaterial(EntityPlayer player, int yOffset) {
        int posX = MathHelper.floor((double)player.posX);
        int posY = MathHelper.floor((double)player.getEntityBoundingBox().minY) + yOffset;
        int posZ = MathHelper.floor((double)player.posZ);
        return BlockUtil.getBlockMaterial(player.world, posX, posY, posZ);
    }

    public static Material getBlockMaterial(World world, int posX, int posY, int posZ) {
        return world.getBlockState(new BlockPos(posX, posY, posZ)).getMaterial();
    }

    public static IBlockState getBlock(World world, RayTraceResult mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.typeOfHit != RayTraceResult.Type.BLOCK) {
            int posX = MathHelper.floor((double)mop.entityHit.posX);
            int posY = MathHelper.floor((double)mop.entityHit.posY) - 1;
            int posZ = MathHelper.floor((double)mop.entityHit.posZ);
            return BlockUtil.getBlock(world, posX, posY, posZ);
        }
        if (before) {
            int x = mop.getBlockPos().getX() + (mop.sideHit == EnumFacing.NORTH ? -1 : (mop.sideHit == EnumFacing.SOUTH ? 1 : 0));
            int y = mop.getBlockPos().getY() + (mop.sideHit == EnumFacing.DOWN ? -1 : (mop.sideHit == EnumFacing.UP ? 1 : 0));
            int z = mop.getBlockPos().getZ() + (mop.sideHit == EnumFacing.EAST ? -1 : (mop.sideHit == EnumFacing.WEST ? 1 : 0));
            if (mop.sideHit == EnumFacing.UP && !world.getBlockState(new BlockPos(x, mop.getBlockPos().getY(), z)).getMaterial().isSolid()) {
                --y;
            }
            return BlockUtil.getBlock(world, x, y, z);
        }
        return BlockUtil.getBlock(world, mop.getBlockPos().getX(), mop.getBlockPos().getY(), mop.getBlockPos().getZ());
    }

    public static BlockPos getBlockCoords(World world, RayTraceResult mop, boolean before) {
        if (mop == null) {
            return null;
        }
        if (mop.typeOfHit != RayTraceResult.Type.BLOCK) {
            return mop.entityHit.getPosition().down();
        }
        if (before) {
            BlockPos pos = mop.getBlockPos();
            if (mop.sideHit == EnumFacing.UP && !world.getBlockState(new BlockPos(pos.getX(), mop.getBlockPos().getY(), pos.getZ())).getMaterial().isSolid()) {
                pos = pos.down();
            }
            return pos;
        }
        return mop.getBlockPos();
    }

    public static void setBlock(World world, int posX, int posY, int posZ, IBlockState state, int updateFlags) {
        world.setBlockState(new BlockPos(posX, posY, posZ), state, updateFlags);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, Block newBlock) {
        world.setBlockState(new BlockPos(posX, posY, posZ), newBlock != null ? newBlock.getDefaultState() : Blocks.AIR.getDefaultState());
    }

    public static void setBlock(World world, double posX, double posY, double posZ, Block block) {
        int x = MathHelper.floor((double)posX);
        int y = MathHelper.floor((double)posY);
        int z = MathHelper.floor((double)posZ);
        BlockUtil.setBlock(world, x, y, z, block);
    }

    public static void setBlock(World world, int posX, int posY, int posZ, ItemBlock item, int damage, int updateFlags) {
        world.setBlockState(new BlockPos(posX, posY, posZ), item.getBlock().getStateFromMeta(damage), updateFlags);
    }

    public static void setBlockState(World world, int posX, int posY, int posZ, IBlockState state) {
        BlockUtil.setBlockState(world, posX, posY, posZ, state, 3);
    }

    public static void setBlockState(World world, int posX, int posY, int posZ, IBlockState state, int updateFlags) {
        world.setBlockState(new BlockPos(posX, posY, posZ), state, updateFlags);
    }

    public static void setAirBlock(World world, int x, int y, int z, int updateFlags) {
        world.setBlockState(new BlockPos(x, y, z), Blocks.AIR.getDefaultState(), updateFlags);
    }

    public static void notifyNeighborsOfBlockChange(World world, BlockPos pos, Block blockType) {
        world.notifyNeighborsRespectDebug(pos, blockType, true);
    }

    public static boolean isMovableBlock(Block block) {
        return block != WitcheryBlocks.ALTAR && block != WitcheryBlocks.VOID_BRAMBLE && block != Blocks.BEDROCK;
    }

    public static boolean isSolid(World world, int posX, int posY, int posZ) {
        IBlockState block = BlockUtil.getBlock(world, posX, posY, posZ);
        return !block.getMaterial().isReplaceable();
    }

    public static boolean isNormalCube(IBlockState block) {
        return block.getMaterial().blocksMovement() && block.isFullCube();
    }

    public static BlockPos getClosestPlantableBlock(World world, BlockPos pos, EnumFacing side, EntityLivingBase entity) {
        return BlockUtil.getClosestPlantableBlock(world, pos, side, entity, false);
    }

    public static BlockPos getClosestPlantableBlock(World world, BlockPos pos, EnumFacing side, EntityLivingBase entity, boolean allowAir) {
        boolean foundBase = false;
        if (!(!BlockUtil.isReplaceableBlock(world, pos) || allowAir && world.isAirBlock(pos))) {
            while (BlockUtil.isReplaceableBlock(world, pos = pos.down())) {
            }
            foundBase = true;
        } else if (side == EnumFacing.UP) {
            foundBase = true;
        } else if (side != EnumFacing.DOWN && BlockUtil.isReplaceableBlock(world, pos = pos.offset(side))) {
            boolean bl = foundBase = !BlockUtil.isReplaceableBlock(world, pos = pos.down());
        }
        if (foundBase) {
            IBlockState replaceBlock = world.getBlockState(pos.up());
            if (WitcheryUtils.isBlockBreakable(world, pos.up(), replaceBlock)) {
                return pos.up();
            }
        }
        return null;
    }

    public static void setBlockIfReplaceable(World world, BlockPos pos, Block block) {
        BlockUtil.setBlockIfReplaceable(world, pos, block.getDefaultState());
    }

    public static boolean setBlockIfReplaceable(World world, BlockPos pos, IBlockState state) {
        if (world.getBlockState(pos).getMaterial().isReplaceable()) {
            world.setBlockState(pos, state, 3);
            return true;
        }
        return false;
    }
}

