/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.util;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class BlockActionReplaceSphere {
    protected abstract boolean onShouldReplace(IBlockState var1);

    protected abstract void onReplaceBlock(World var1, BlockPos var2);

    public void replaceBlocks(World world, BlockPos pos, int radius) {
        this.replaceBlocks(world, pos, pos, radius);
    }

    private void replaceBlocks(World world, BlockPos pos, BlockPos pos1, int range) {
        double rangeSq = range * range;
        if (pos.distanceSq((Vec3i)pos1) >= rangeSq) {
            return;
        }
        if (this.replaceBlock(world, pos.east())) {
            this.replaceBlocks(world, pos.east(), pos1, range);
        }
        if (this.replaceBlock(world, pos.west())) {
            this.replaceBlocks(world, pos.west(), pos1, range);
        }
        if (this.replaceBlock(world, pos.south())) {
            this.replaceBlocks(world, pos.south(), pos1, range);
        }
        if (this.replaceBlock(world, pos.north())) {
            this.replaceBlocks(world, pos.north(), pos1, range);
        }
        if (this.replaceBlock(world, pos.up())) {
            this.replaceBlocks(world, pos.up(), pos1, range);
        }
        if (this.replaceBlock(world, pos.down())) {
            this.replaceBlocks(world, pos.down(), pos1, range);
        }
    }

    private boolean replaceBlock(World world, BlockPos pos) {
        IBlockState block = world.getBlockState(pos);
        if (this.onShouldReplace(block)) {
            this.onReplaceBlock(world, pos);
            return true;
        }
        return false;
    }
}

