/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectWeatherCallStorm
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectWeatherCallStorm> DESERIALIZER = json -> new RiteEffectWeatherCallStorm(JsonUtils.getInt((JsonObject)json, (String)"min_radius"), JsonUtils.getInt((JsonObject)json, (String)"max_radius"), JsonUtils.getInt((JsonObject)json, (String)"bolts"));
    private final int minRadius;
    private final int maxRadius;
    private final int bolts;

    public RiteEffectWeatherCallStorm(int minRadius, int maxRadius, int bolts) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.bolts = bolts;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        switch (stage.incrementAndGet()) {
            case 1: 
            case 2: {
                this.spawnBolt(world, pos);
                break;
            }
            case 3: {
                this.spawnBolt(world, pos);
                this.spawnBolt(world, pos);
                break;
            }
            case 4: {
                if (world instanceof WorldServer && !world.isThundering()) {
                    WorldInfo worldinfo = world.getWorldInfo();
                    int i = (300 + world.rand.nextInt(600)) * 20;
                    worldinfo.setRainTime(i);
                    worldinfo.setThunderTime(i);
                    worldinfo.setRaining(true);
                    worldinfo.setThundering(true);
                }
                this.spawnBolt(world, pos);
                break;
            }
            default: {
                for (int j = 0; j < world.rand.nextInt(4); ++j) {
                    this.spawnBolt(world, pos);
                    if (j <= 0) continue;
                    stage.incrementAndGet();
                }
            }
        }
        return stage.get() < this.bolts ? RiteHandler.Result.STARTING : RiteHandler.Result.COMPLETED;
    }

    private void spawnBolt(World world, BlockPos pos) {
        int activeRadius = this.maxRadius - this.minRadius;
        int ax = world.rand.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += this.minRadius * 2;
        }
        int x = pos.getX() - this.maxRadius + ax;
        int az = world.rand.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += this.minRadius * 2;
        }
        int z = pos.getZ() - this.maxRadius + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)pos.getY(), (double)z, false);
        world.addWeatherEffect((Entity)bolt);
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

