/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectTransposeOres
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectTransposeOres> DESERIALIZER = json -> {
        Int2ObjectOpenHashMap states = new Int2ObjectOpenHashMap();
        JsonObject covenSizeBlocks = JsonUtils.getJsonObject((JsonObject)json, (String)"coven_size_blocks");
        for (Map.Entry entry2 : covenSizeBlocks.entrySet()) {
            states.put(Integer.parseInt((String)entry2.getKey()), (Object)CollectionsKt.mapTo((Iterable)((JsonElement)entry2.getValue()).getAsJsonArray(), new HashSet(), it -> WitcheryUtils.parseBlockState(it.getAsString())));
        }
        return new RiteEffectTransposeOres(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)8), JsonUtils.getInt((JsonObject)json, (String)"pulses", (int)30), (Int2ObjectMap<Set<IBlockState>>)states);
    };
    protected final int radius;
    protected final int pulses;
    protected final Int2ObjectMap<Set<IBlockState>> blocks;

    public RiteEffectTransposeOres(int radius, int pulses, Int2ObjectMap<Set<IBlockState>> blocks) {
        this.radius = radius;
        this.pulses = pulses;
        this.blocks = blocks;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos position, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        stage.incrementAndGet();
        block0: for (BlockPos pos : BlockPos.getAllInBox((BlockPos)position.add(-this.radius, -stage.get(), -this.radius), (BlockPos)position.add(this.radius, -stage.get(), this.radius))) {
            IBlockState state = world.getBlockState(pos);
            for (int i = ritual.covenSize; i >= 0; --i) {
                Set allowedStates = (Set)this.blocks.get(i);
                if (!allowedStates.contains(state)) continue;
                ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().damageDropped(state));
                if (stack.isEmpty()) continue block0;
                EntityItem entity = new EntityItem(world, (double)(position.getX() - this.radius + world.rand.nextInt(2 * this.radius + 1)), (double)(position.getY() - stage.get() + 2), (double)(position.getZ() - this.radius + world.rand.nextInt(2 * this.radius + 1)), stack);
                if (world.isRemote) continue block0;
                world.setBlockToAir(pos);
                world.spawnEntity((Entity)entity);
                continue block0;
            }
        }
        return stage.get() >= this.pulses + 5 * ritual.covenSize || position.getY() - stage.get() <= 2 ? RiteHandler.Result.COMPLETED : RiteHandler.Result.UPKEEP;
    }

    @Override
    public int getRunTime() {
        return 10;
    }
}

