/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.effect.RiteEffectTeleportation;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;

public class RiteEffectTeleportToWaystone
extends RiteEffectTeleportation {
    public static final Function1<JsonObject, RiteEffectTeleportToWaystone> DESERIALIZER = json -> new RiteEffectTeleportToWaystone(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()), JsonUtils.getInt((JsonObject)json, (String)"radius", (int)3));
    private final long target;

    public RiteEffectTeleportToWaystone(long target, int radius) {
        super(radius);
        this.target = target;
    }

    @Override
    protected boolean teleport(World world, BlockPos pos, TileEntityCircle.ActivatedRitual ritual) {
        RiteEffect.SacrificedItem sacrificedItem;
        if (!world.isRemote && (sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target)) != null) {
            ItemStack waystoneStack = sacrificedItem.getStack();
            AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-this.radius, -this.radius, -this.radius), pos.add(this.radius, this.radius, this.radius));
            List list2 = world.getEntitiesWithinAABB(Entity.class, bounds);
            boolean sent = false;
            for (Entity entity : list2) {
                if (!(entity.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)this.radius) || !PotionEnderInhibition.canTeleport(entity, 1) || !WitcheryIngredientItem.teleportToLocation(world, waystoneStack, entity, this.radius, true)) continue;
                sent = true;
            }
            return sent;
        }
        return false;
    }
}

