/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.item.ItemSpectralStone;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectSummonSpectralStone
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectSummonSpectralStone> DESERIALIZER = json -> new RiteEffectSummonSpectralStone((Set)CollectionsKt.mapNotNullTo((Iterable)json.getAsJsonArray("entities"), new HashSet(), it -> EntityList.getClass((ResourceLocation)new ResourceLocation(it.getAsString()))), JsonUtils.getInt((JsonObject)json, (String)"radius", (int)5));
    private final Set<Class<? extends Entity>> entities;
    private final int radius;

    public RiteEffectSummonSpectralStone(Set<Class<? extends Entity>> entities, int radius) {
        this.entities = entities;
        this.radius = radius;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        Class<?> entityType = null;
        int count = 0;
        for (EntityCreature entity : world.getEntitiesWithinAABB(EntityCreature.class, new AxisAlignedBB(pos.add(-this.radius, -this.radius, -this.radius), pos.add(this.radius, this.radius, this.radius)))) {
            Class<?> foundType = entity.getClass();
            if (!this.entities.contains(foundType) || !(entity.getDistanceSq(pos) <= (double)(this.radius * this.radius))) continue;
            if (entityType == null) {
                entityType = foundType;
            }
            if (entityType != foundType) continue;
            entity.setDead();
            entity.world.playSound(null, entity.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 1.0f, 2.0f, EnumParticleTypes.PORTAL), (Entity)entity);
            if (++count < 3) continue;
            break;
        }
        if (count <= 0) {
            RiteEffect.error("missing_creature_sacrifice", ritual.getInitiatingPlayer(world));
            return RiteHandler.Result.ABORTED_REFUND;
        }
        ItemStack stack = ItemSpectralStone.makeStack(entityType, count);
        if (!stack.isEmpty()) {
            EntityItem entity2 = new EntityItem(world, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, stack);
            entity2.motionX = 0.0;
            entity2.motionY = 0.3;
            entity2.motionZ = 0.0;
            world.spawnEntity((Entity)entity2);
            entity2.world.playSound(null, entity2.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity2.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity2.posX, entity2.posY, entity2.posZ, 0.5f, 0.5f, EnumParticleTypes.SPELL), (Entity)entity2);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

