/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectSummonCreature
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectSummonCreature> DESERIALIZER = json -> new RiteEffectSummonCreature((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(json.get("entity").getAsString())), JsonUtils.getBoolean((JsonObject)json, (String)"persistent", (boolean)false), JsonUtils.getBoolean((JsonObject)json, (String)"tame", (boolean)false), JsonUtils.getInt((JsonObject)json, (String)"coven_size", (int)0));
    private final EntityEntry creatureToSummon;
    private final boolean tame;
    private final boolean persistent;
    private final int covenSize;

    public RiteEffectSummonCreature(EntityEntry creatureToSummon, boolean tame, boolean persistent, int covenSize) {
        this.creatureToSummon = creatureToSummon;
        this.tame = tame;
        this.persistent = persistent;
        this.covenSize = covenSize;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            int[][] pattern = new int[][]{{0, 0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 2, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 0}};
            int obstructions = 0;
            BlockPos y = pos.up();
            while (y.getY() <= pos.getY() + 3) {
                int offsetZ = (pattern.length - 1) / 2;
                for (int z = 0; z < pattern.length - 1; ++z) {
                    int offsetX = (pattern[z].length - 1) / 2;
                    for (int x = 0; x < pattern[z].length; ++x) {
                        Material material;
                        int val = pattern[pattern.length - 1 - z][x];
                        BlockPos p = y.add(x - offsetX, 0, z - offsetZ);
                        if (val == 1) {
                            material = world.getBlockState(p).getMaterial();
                            if (!material.isSolid()) continue;
                            ++obstructions;
                            continue;
                        }
                        if (val != 2 || !(material = world.getBlockState(p).getMaterial()).isSolid()) continue;
                        obstructions += 100;
                    }
                }
                y = y.up();
            }
            if (obstructions > 1) {
                world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.5f, 2.0f, EnumParticleTypes.SMOKE_LARGE), world, pos);
                RiteEffect.error("circle_center_unclear", ritual.getInitiatingPlayer(world));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            Entity entity = this.creatureToSummon.newInstance(world);
            if (ritual.covenSize < this.covenSize) {
                EntityPlayer player = ritual.getInitiatingPlayer(world);
                world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                if (player != null) {
                    player.sendMessage(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                }
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (this.tame) {
                EntityTameable tameable = (EntityTameable)entity;
                tameable.setOwnerId(ritual.getInitiatingPlayerId());
                tameable.setTamed(true);
            }
            if (this.persistent) {
                ((EntityLiving)entity).enablePersistence();
            }
            entity.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1.0f, 0.0f);
            world.spawnEntity(entity);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
            }
            entity.world.playSound(null, entity.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (entity.world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(entity.posX, entity.posY, entity.posZ, 0.5f, 1.0f, EnumParticleTypes.PORTAL), entity);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

