/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectSphereEffect
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectSphereEffect> DESERIALIZER = json -> new RiteEffectSphereEffect(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)8), WitcheryUtils.parseBlockState(JsonUtils.getString((JsonObject)json, (String)"block")));
    protected final int maxRadius;
    private final IBlockState block;

    public RiteEffectSphereEffect(int radius, IBlockState block) {
        this.maxRadius = radius;
        this.block = block;
    }

    private static void fillHalfWithAirY(World world, BlockPos pos, int dy, int radius, IBlockState removalBlock) {
        BlockPos real;
        for (int y = 0; y <= radius && world.getBlockState(real = pos.up(y * dy)).getBlock() != removalBlock.getBlock(); ++y) {
            RiteEffectSphereEffect.fillHalfWithAirX(world, real, 1, radius, removalBlock);
            RiteEffectSphereEffect.fillHalfWithAirX(world, real.west(), -1, radius, removalBlock);
        }
    }

    private static void fillHalfWithAirX(World world, BlockPos pos, int dx, int radius, IBlockState removalBlock) {
        BlockPos real;
        for (int x = 0; x <= radius && world.getBlockState(real = pos.east(x * dx)).getBlock() != removalBlock; ++x) {
            RiteEffectSphereEffect.fillHalfWithAirZ(world, real, 1, radius, removalBlock);
            RiteEffectSphereEffect.fillHalfWithAirZ(world, real.north(), -1, radius, removalBlock);
        }
    }

    private static void fillHalfWithAirZ(World world, BlockPos pos, int dz, int radius, IBlockState removalBlock) {
        BlockPos real;
        Block foundBlock;
        for (int z = 0; z <= radius && (foundBlock = world.getBlockState(real = pos.south(z * dz)).getBlock()) != removalBlock.getBlock(); ++z) {
            if (foundBlock != Blocks.WATER && foundBlock != Blocks.FLOWING_WATER) continue;
            world.setBlockToAir(real);
        }
    }

    private void drawSphere(World world, BlockPos pos, int radius, IBlockState state) {
        int x = radius;
        int radiusError = 1 - x;
        for (int y = 0; x >= y; ++y) {
            this.drawCircle(world, pos, y, x, radiusError, state);
            if (radiusError < 0) {
                radiusError += 2 * y + 1;
                continue;
            }
            radiusError += 2 * (y - --x + 1);
        }
    }

    private void drawCircle(World world, BlockPos pos, int y, int radius, int error0, IBlockState state) {
        int x = radius;
        int radiusError = error0;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, pos.add(x, y, z), state);
            this.drawPixel(world, pos.add(-x, y, z), state);
            this.drawPixel(world, pos.add(x, -y, z), state);
            this.drawPixel(world, pos.add(-x, -y, z), state);
            this.drawPixel(world, pos.add(x, y, -z), state);
            this.drawPixel(world, pos.add(-x, y, -z), state);
            this.drawPixel(world, pos.add(x, -y, -z), state);
            this.drawPixel(world, pos.add(-x, -y, -z), state);
            this.drawPixel(world, pos.add(z, y, x), state);
            this.drawPixel(world, pos.add(-z, y, x), state);
            this.drawPixel(world, pos.add(z, -y, x), state);
            this.drawPixel(world, pos.add(-z, -y, x), state);
            this.drawPixel(world, pos.add(z, y, -x), state);
            this.drawPixel(world, pos.add(-z, y, -x), state);
            this.drawPixel(world, pos.add(z, -y, -x), state);
            this.drawPixel(world, pos.add(-z, -y, -x), state);
            this.drawPixel(world, pos.add(y, x, z), state);
            this.drawPixel(world, pos.add(-y, x, z), state);
            this.drawPixel(world, pos.add(y, -x, z), state);
            this.drawPixel(world, pos.add(-y, -x, z), state);
            this.drawPixel(world, pos.add(y, x, -z), state);
            this.drawPixel(world, pos.add(-y, x, -z), state);
            this.drawPixel(world, pos.add(y, -x, -z), state);
            this.drawPixel(world, pos.add(-y, -x, -z), state);
            this.drawPixel(world, pos.add(z, x, y), state);
            this.drawPixel(world, pos.add(-z, x, y), state);
            this.drawPixel(world, pos.add(z, -x, y), state);
            this.drawPixel(world, pos.add(-z, -x, y), state);
            this.drawPixel(world, pos.add(z, x, -y), state);
            this.drawPixel(world, pos.add(-z, x, -y), state);
            this.drawPixel(world, pos.add(z, -x, -y), state);
            this.drawPixel(world, pos.add(-z, -x, -y), state);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    private void drawPixel(World world, BlockPos pos, IBlockState state) {
        IBlockState oldState = world.getBlockState(pos);
        Block currentBlock = oldState.getBlock();
        if ((currentBlock == Blocks.WATER || currentBlock == Blocks.FLOWING_WATER || currentBlock == Blocks.AIR || currentBlock == Blocks.ICE || currentBlock == Blocks.SNOW || currentBlock == Blocks.TALLGRASS || currentBlock == Blocks.VINE || currentBlock == Blocks.WATERLILY || currentBlock == Blocks.RED_FLOWER || currentBlock == Blocks.YELLOW_FLOWER || currentBlock == Blocks.CACTUS || currentBlock == Blocks.DEADBUSH || currentBlock == WitcheryBlocks.PERPETUAL_ICE) && oldState != state) {
            world.setBlockState(pos, state);
        }
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ticks < 20) {
            return RiteHandler.Result.STARTING;
        }
        if (ticks == 20) {
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        }
        EntityPlayer player = ritual.getInitiatingPlayer(world);
        if (ritual.covenSize < 2) {
            world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        stage.incrementAndGet();
        int maxRadius = (int)(ritual.covenSize <= 2 ? (double)this.maxRadius : (ritual.covenSize <= 5 ? 1.5 * (double)this.maxRadius : 2.0 * (double)this.maxRadius));
        int currentRadius = stage.get() + 4;
        if (currentRadius <= maxRadius) {
            if (stage.get() % 2 == 0) {
                this.drawSphere(world, pos, currentRadius, this.block);
                this.drawSphere(world, pos, currentRadius - 2, Blocks.AIR.getDefaultState());
            }
            if (currentRadius == maxRadius) {
                RiteEffectSphereEffect.fillHalfWithAirY(world, pos, 1, maxRadius, this.block);
                RiteEffectSphereEffect.fillHalfWithAirY(world, pos.down(), -1, maxRadius, this.block);
            }
        }
        return stage.get() > 250 || currentRadius >= maxRadius ? RiteHandler.Result.COMPLETED : RiteHandler.Result.UPKEEP;
    }

    @Override
    public int getRunTime() {
        return 5;
    }
}

