/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectRaiseVolcano
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectRaiseVolcano> DESERIALIZER = json -> new RiteEffectRaiseVolcano(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)8), JsonUtils.getInt((JsonObject)json, (String)"height", (int)8));
    private final int radius;
    private final int height;

    public RiteEffectRaiseVolcano(int radius, int height2) {
        this.radius = radius;
        this.height = height2;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if ((long)ticks % 15L != 0L) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.isRemote) {
            if (stage.incrementAndGet() == 1) {
                boolean lavaFound = false;
                BlockPos y = pos;
                while (y.getY() > 0 && !lavaFound) {
                    Block blockID = world.getBlockState(y).getBlock();
                    if (blockID == Blocks.LAVA && this.surroundedByBlocks(world, y)) {
                        lavaFound = true;
                    } else if (blockID == Blocks.BEDROCK) break;
                    y = y.down();
                }
                if (!lavaFound) {
                    world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    RiteEffect.error("no_lava", ritual.getInitiatingPlayer(world));
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.PORTAL), world, pos);
            }
            int height2 = this.height + 4 * ritual.covenSize;
            float radius = this.radius + 2 * ritual.covenSize;
            if (stage.get() <= height2) {
                for (int y2 = 1; y2 <= stage.get(); ++y2) {
                    float r = radius - (float)(height2 - stage.get() - 1 + y2) * radius / (float)height2;
                    AxisAlignedBB bounds = new AxisAlignedBB(pos.add((double)(-r), (double)y2, (double)(-r)), pos.add((double)r, (double)y2, (double)r));
                    this.drawFilledCircle(world, pos.up(y2 - 1), Math.max((int)Math.ceil(r), 1), y2, true);
                    if (stage.get() == height2) {
                        int reduce = 0;
                        BlockPos minusY = pos.down();
                        while (minusY.getY() > pos.getY() - 5) {
                            this.drawFilledCircle(world, minusY, Math.max((int)radius - reduce, 2), y2, false);
                            minusY = minusY.down();
                            ++reduce;
                        }
                    }
                    for (Entity entity : world.getEntitiesWithinAABB(Entity.class, bounds)) {
                        Material material;
                        if (!(pos.up(y2).getDistance((int)entity.posX, (int)entity.posY, (int)entity.posZ) <= (double)r) || !(material = world.getBlockState(entity.getPosition()).getMaterial()).isSolid()) continue;
                        if (entity instanceof EntityLivingBase) {
                            entity.setPositionAndUpdate(entity.posX, entity.posY + 1.0, entity.posZ);
                            continue;
                        }
                        entity.setPosition(entity.posX, entity.posY + 1.0, entity.posZ);
                    }
                }
            } else {
                if (stage.get() >= height2 * 2) {
                    BlockPos p = pos;
                    while (p.getY() > 0) {
                        Block blockID2 = world.getBlockState(p).getBlock();
                        if (blockID2 == Blocks.LAVA || blockID2 == Blocks.FLOWING_LAVA || blockID2 == Blocks.BEDROCK) {
                            while (blockID2 == Blocks.LAVA || blockID2 == Blocks.FLOWING_LAVA) {
                                this.setToAirIfLava(world, p);
                                this.setToAirIfLava(world, p.east());
                                this.setToAirIfLava(world, p.west());
                                this.setToAirIfLava(world, p.south());
                                this.setToAirIfLava(world, p.north());
                                p = p.down();
                                blockID2 = world.getBlockState(p).getBlock();
                            }
                            break;
                        }
                        world.setBlockToAir(p);
                        p = p.down();
                    }
                    return RiteHandler.Result.COMPLETED;
                }
                if (stage.get() == height2 * 2 - 1) {
                    world.setBlockState(pos.up(stage.get() - height2), Blocks.FLOWING_LAVA.getDefaultState());
                    world.setBlockState(pos.up(), Blocks.LAVA.getDefaultState());
                    if (radius == 16.0f) {
                        if (world.rand.nextInt(4) == 0) {
                            world.setBlockState(pos.up(1 + stage.get() - height2), Blocks.FLOWING_LAVA.getDefaultState());
                        }
                    } else {
                        switch (world.rand.nextInt(8)) {
                            case 0: {
                                world.setBlockToAir(pos.add(1, height2 - 1, 0));
                                break;
                            }
                            case 1: {
                                world.setBlockToAir(pos.add(0, height2 - 1, 1));
                                break;
                            }
                            case 2: {
                                world.setBlockToAir(pos.add(-1, height2 - 1, 0));
                                break;
                            }
                            case 3: {
                                world.setBlockToAir(pos.add(0, height2 - 1, -1));
                            }
                        }
                    }
                } else {
                    world.setBlockState(pos.up(), Blocks.STONE.getDefaultState());
                    world.setBlockState(pos.up(stage.get() - height2), Blocks.LAVA.getDefaultState());
                }
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    private boolean surroundedByBlocks(World world, BlockPos pos) {
        int count = 0;
        count += world.getBlockState(pos.down()).getBlock() == Blocks.LAVA ? 1 : 0;
        count += world.getBlockState(pos.west()).getBlock() == Blocks.LAVA ? 1 : 0;
        count += world.getBlockState(pos.add(1, -1, 0)).getBlock() == Blocks.LAVA ? 1 : 0;
        count += world.getBlockState(pos.north()).getBlock() == Blocks.LAVA ? 1 : 0;
        count += world.getBlockState(pos.south()).getBlock() == Blocks.LAVA ? 1 : 0;
        return (count += world.getBlockState(pos.add(0, 1, 1)).getBlock() == Blocks.LAVA ? 1 : 0) >= 2;
    }

    private void setToAirIfLava(World world, BlockPos pos) {
        Block blockID = world.getBlockState(pos).getBlock();
        if (blockID == Blocks.LAVA || blockID == Blocks.FLOWING_LAVA) {
            world.setBlockToAir(pos);
        }
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, int height2, boolean replaceBlocks) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.add(-x, 0, z), pos.add(x, 0, z), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.add(-z, 0, x), pos.add(z, 0, x), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.add(-x, 0, -z), pos.add(x, 0, -z), pos, radius, height2, replaceBlocks);
            this.drawLine(world, pos.add(-z, 0, -x), pos.add(z, 0, -x), pos, radius, height2, replaceBlocks);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, BlockPos mid, int radius, int height2, boolean replaceBlocks) {
        BlockPos modX1 = radius > 1 && world.rand.nextInt(5) == 0 ? x1.east() : x1;
        BlockPos modX2 = radius > 1 && world.rand.nextInt(5) == 0 ? x2.west() : x2;
        boolean edgeZ = mid.getZ() + radius == x1.getZ() || mid.getZ() - radius == x1.getZ();
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)modX1, (BlockPos)modX2)) {
            if (pos.equals((Object)mid)) continue;
            this.drawPixel(world, pos, (pos.equals((Object)modX1) || pos.equals((Object)modX2) || edgeZ) && height2 < 3, replaceBlocks);
        }
    }

    protected void drawPixel(World world, BlockPos pos, boolean lower, boolean replaceBlocks) {
        if (replaceBlocks && WitcheryUtils.canBreak(world.getBlockState(pos)) || world.isAirBlock(pos)) {
            world.setBlockState(pos, lower && world.rand.nextInt(5) != 0 ? Blocks.GRASS.getDefaultState() : Blocks.STONE.getDefaultState());
        }
    }
}

