/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.passive.EntityToad;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectRainOfToads
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectRainOfToads> DESERIALIZER = json -> new RiteEffectRainOfToads(JsonUtils.getInt((JsonObject)json, (String)"min_radius", (int)5), JsonUtils.getInt((JsonObject)json, (String)"max_radius", (int)16), JsonUtils.getInt((JsonObject)json, (String)"bolts", (int)10));
    private final int minRadius;
    private final int maxRadius;
    private final int bolts;

    public RiteEffectRainOfToads(int minRadius, int maxRadius, int bolts) {
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
        this.bolts = bolts;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ritual.covenSize < 1) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        switch (stage.incrementAndGet()) {
            case 1: 
            case 2: 
            case 3: {
                this.spawnBolt(world, pos);
                return RiteHandler.Result.STARTING;
            }
            case 4: {
                if (world instanceof WorldServer && !world.isRaining()) {
                    WorldInfo worldinfo = world.getWorldInfo();
                    int i = (300 + world.rand.nextInt(600)) * 20;
                    worldinfo.setRainTime(i);
                    worldinfo.setRaining(true);
                }
                this.spawnBolt(world, pos);
                return RiteHandler.Result.STARTING;
            }
        }
        int activeRadius = this.maxRadius - this.minRadius;
        for (int n = 0; n < world.rand.nextInt(this.bolts) + 8; ++n) {
            int az;
            int ax = world.rand.nextInt(activeRadius * 2 + 1);
            if (ax > activeRadius) {
                ax += this.minRadius * 2;
            }
            if ((az = world.rand.nextInt(activeRadius * 2 + 1)) > activeRadius) {
                az += this.minRadius * 2;
            }
            if (!world.isAirBlock(pos = world.getTopSolidOrLiquidBlock(pos.add(ax - this.maxRadius, 0, az - this.maxRadius)))) continue;
            EntityToad toad2 = new EntityToad(world);
            toad2.setLocationAndAngles(pos.getX(), pos.getY() + 8 + world.rand.nextInt(7), pos.getZ(), 0.0f, 0.0f);
            toad2.setTimeToLive(30, true);
            world.spawnEntity((Entity)toad2);
        }
        return stage.get() < 200 ? RiteHandler.Result.UPKEEP : RiteHandler.Result.COMPLETED;
    }

    private void spawnBolt(World world, BlockPos pos) {
        int activeRadius = this.maxRadius - this.minRadius;
        int ax = world.rand.nextInt(activeRadius * 2 + 1);
        if (ax > activeRadius) {
            ax += this.minRadius * 2;
        }
        int x = pos.getX() - this.maxRadius + ax;
        int az = world.rand.nextInt(activeRadius * 2 + 1);
        if (az > activeRadius) {
            az += this.minRadius * 2;
        }
        int z = pos.getZ() - this.maxRadius + az;
        EntityLightningBolt bolt = new EntityLightningBolt(world, (double)x, (double)pos.getY(), (double)z, false);
        world.addWeatherEffect((Entity)bolt);
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

