/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.msrandom.witchery.rite.effect.RiteEffectProtectionCircle;

public class RiteEffectProtectionCircleAttractive
extends RiteEffectProtectionCircle {
    public static final Function1<JsonObject, RiteEffectProtectionCircleAttractive> DESERIALIZER = json -> new RiteEffectProtectionCircleAttractive(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)4), JsonUtils.getFloat((JsonObject)json, (String)"power", (float)0.8f), JsonUtils.getInt((JsonObject)json, (String)"lifetime", (int)0));

    public RiteEffectProtectionCircleAttractive(int radius, float upkeepPowerCost, int ticksToLive) {
        super(radius, upkeepPowerCost, ticksToLive);
    }

    @Override
    protected void update(World world, BlockPos pos, int radius, int ticks) {
        this.attract(world, pos, radius);
    }

    private void attract(World world, BlockPos pos, float radius) {
        AxisAlignedBB bounds = new AxisAlignedBB(pos.add((double)(-radius), (double)(-radius), (double)(-radius)), pos.add((double)radius, (double)radius, (double)radius));
        List list2 = world.getEntitiesWithinAABB(EntityCreature.class, bounds);
        for (Entity entity : list2) {
            if (!(entity.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)radius)) continue;
            this.pull(entity, pos, radius);
        }
    }

    private void pull(Entity entity, BlockPos pos, float radius) {
        double distance;
        if (!(entity instanceof EntityPlayer) && !(entity instanceof EntityDragon) && (distance = pos.getDistance((int)(entity.posX + entity.motionX), (int)(entity.posY + entity.motionY), (int)(entity.posZ + entity.motionZ))) >= (double)(radius - 1.0f)) {
            double d = (double)pos.getX() - entity.posX;
            double d2 = (double)pos.getY() - entity.posY;
            double d3 = (double)pos.getZ() - entity.posZ;
            double d4 = d * d + d2 * d2 + d3 * d3;
            if ((d4 *= d4) <= Math.pow(6.0, 4.0)) {
                double d5 = -(d * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                double d6 = -(d2 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                double d7 = -(d3 * 0.01999999955296516 / d4) * Math.pow(6.0, 3.0);
                if (d5 > 0.0) {
                    d5 = 0.22;
                } else if (d5 < 0.0) {
                    d5 = -0.22;
                }
                if (d6 > 0.2) {
                    d6 = 0.12;
                } else if (d6 < -0.1) {
                    d6 = 0.12;
                }
                if (d7 > 0.0) {
                    d7 = 0.22;
                } else if (d7 < 0.0) {
                    d7 = -0.22;
                }
                Vec3d vec = new Vec3d(d5, d6, d7).rotateYaw(180.0f);
                entity.motionX = vec.x;
                entity.motionY = 0.0;
                entity.motionZ = vec.z;
            }
        }
    }
}

