/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.integration.IntegrationManager;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectPriorIncarnation
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectPriorIncarnation> DESERIALIZER = json -> new RiteEffectPriorIncarnation(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)5), JsonUtils.getInt((JsonObject)json, (String)"aoe", (int)16));
    public static final String PRIOR_INV_KEY = "WitcheryPriIncInv";
    public static final String PRIOR_USR_KEY = "WitcheryPriIncUsr";
    public static final String PRIOR_LOC_KEY = "WitcheryPriIncLoc";
    private final int radius;
    private final int aoe;

    public RiteEffectPriorIncarnation(int radius, int aoe) {
        this.radius = radius;
        this.aoe = aoe;
    }

    public static boolean isRitualAllowed() {
        return IntegrationManager.allowsDeathItemRecovery();
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!RiteEffectPriorIncarnation.isRitualAllowed() || world.getGameRules().getBoolean("keepInventory")) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.disabled", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if (stage.get() == 0) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.isRemote) {
            int r = this.radius;
            AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-r, 0, -r), pos.add(r, 1, r));
            boolean found = false;
            for (EntityPlayer player2 : world.getEntitiesWithinAABB(EntityPlayer.class, bounds)) {
                double z;
                double y;
                NBTTagCompound nbt;
                if (!(player2.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)r) || !(nbt = player2.getEntityData()).hasKey(PRIOR_INV_KEY) || !nbt.hasKey("WitcheryPriIncLocX") || !nbt.hasKey("WitcheryPriIncLocY") || !nbt.hasKey("WitcheryPriIncLocZ")) continue;
                NBTTagList tagList = nbt.getTagList(PRIOR_INV_KEY, 10);
                double x = nbt.getDouble("WitcheryPriIncLocX");
                double dSq = pos.distanceSq(x, y = nbt.getDouble("WitcheryPriIncLocY"), z = nbt.getDouble("WitcheryPriIncLocZ"));
                if (dSq > (double)(this.aoe * this.aoe) || tagList.tagCount() <= 0) continue;
                for (int i = 0; i < tagList.tagCount(); ++i) {
                    NBTTagCompound tag = tagList.getCompoundTagAt(i);
                    ItemStack stack = new ItemStack(tag);
                    if (stack.isEmpty()) continue;
                    world.spawnEntity((Entity)new EntityItem(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack));
                }
                EntitySkeleton skeleton = new EntitySkeleton(world);
                skeleton.setLocationAndAngles((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 0.0f, 0.0f);
                skeleton.setCustomNameTag(player2.getName());
                world.spawnEntity((Entity)skeleton);
                nbt.removeTag(PRIOR_INV_KEY);
                nbt.removeTag("WitcheryPriIncLocX");
                nbt.removeTag("WitcheryPriIncLocY");
                nbt.removeTag("WitcheryPriIncLocZ");
                found = true;
            }
            if (found) {
                world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 3.0f, 3.0f, EnumParticleTypes.EXPLOSION_HUGE), world, pos);
            } else {
                world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SMOKE_NORMAL), world, pos);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }
}

