/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockLeaves;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryWoodTypes;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.BlockStatePredicate;
import net.msrandom.witchery.util.MutableBlock;

public class RiteEffectNaturesPower
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectNaturesPower> DESERIALIZER = json -> new RiteEffectNaturesPower(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)14), JsonUtils.getInt((JsonObject)json, (String)"height", (int)8), JsonUtils.getInt((JsonObject)json, (String)"duration", (int)150), JsonUtils.getInt((JsonObject)json, (String)"expanse", (int)2));
    private final int radius;
    private final int height;
    private final int duration;
    private final int expanse;

    public RiteEffectNaturesPower(int radius, int height2, int duration, int expanse) {
        this.radius = radius;
        this.height = height2;
        this.duration = duration;
        this.expanse = expanse;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.isRemote) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() < this.duration + ritual.covenSize * 5) {
            int modradius = this.radius + ritual.covenSize * 2;
            pos = pos.add(world.rand.nextInt(modradius * 2) - modradius, -1, world.rand.nextInt(modradius * 2) - modradius);
            int height2 = -1;
            world.playEvent(2005, pos.up(2), 0);
            Material material = world.getBlockState(pos).getMaterial();
            if (!material.isSolid() || !world.isAirBlock(pos.up())) {
                for (int h = 1; h < this.height; ++h) {
                    material = world.getBlockState(pos.up(h)).getMaterial();
                    if (material.isSolid() && world.isAirBlock(pos.up(h + 1))) {
                        height2 = h;
                    } else {
                        material = world.getBlockState(pos.down(h)).getMaterial();
                        BlockPos p = pos.down(h - 1);
                        if (!material.isSolid() || !world.isAirBlock(p) && world.getBlockState(p).getBlock() != Blocks.SNOW) continue;
                        height2 = -h;
                    }
                    break;
                }
            } else {
                height2 = 0;
            }
            if (height2 != -1) {
                world.playEvent(2005, pos.up(height2 + 1), 0);
                this.drawFilledCircle(world, pos.up(height2), this.expanse + 1);
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.add(-x, 0, z), pos.add(x, 0, z), radius);
            this.drawLine(world, pos.add(-z, 0, x), pos.add(z, 0, x), radius);
            this.drawLine(world, pos.add(-x, 0, -z), pos.add(x, 0, -z), radius);
            this.drawLine(world, pos.add(-z, 0, -x), pos.add(z, 0, -x), radius);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, int radius) {
        BlockPos modX1 = radius > 1 && world.rand.nextInt(5) == 0 ? x1.east() : x1;
        BlockPos modX2 = radius > 1 && world.rand.nextInt(5) == 0 ? x2.west() : x2;
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)modX1, (BlockPos)modX2)) {
            this.drawPixel(world, pos);
        }
    }

    private boolean isNeighbourBlockID(World world, BlockPos pos) {
        return world.getBlockState(pos.east()).getBlock() == Blocks.WATER || world.getBlockState(pos.west()).getBlock() == Blocks.WATER || world.getBlockState(pos.south()).getBlock() == Blocks.WATER || world.getBlockState(pos.north()).getBlock() == Blocks.WATER;
    }

    /*
     * Unable to fully structure code
     */
    protected void drawPixel(World world, BlockPos pos) {
        block6: {
            block7: {
                up = pos.up();
                state = world.getBlockState(pos);
                block = state.getBlock();
                above = world.getBlockState(up);
                materialAbove = above.getMaterial();
                if (materialAbove.isSolid()) break block6;
                matches = false;
                for (BlockStatePredicate naturePowerReplaceableBlock : WitcheryConfigOptions.naturePowerReplaceableBlocks) {
                    if (naturePowerReplaceableBlock.getBlock() != block || !naturePowerReplaceableBlock.getProperties().matches(state)) continue;
                    matches = true;
                    break;
                }
                if (!matches || world.rand.nextInt(8) == 0) break block7;
                if (materialAbove == Material.VINE) ** GOTO lbl-1000
                v0 = world.rand.nextDouble();
                v1 = this.isNeighbourBlockID(world, pos) != false ? 0.7 : 0.02;
                if (v0 <= v1) {
                    world.setBlockState(pos, Blocks.WATER.getDefaultState());
                } else lbl-1000:
                // 2 sources

                {
                    world.setBlockState(pos, Blocks.GRASS.getDefaultState());
                }
                block = Blocks.GRASS;
            }
            if (materialAbove != Material.VINE && block != Blocks.AIR && block != Blocks.LEAVES && !(block instanceof WitcheryBlockLeaves) && world.rand.nextInt(4) == 0) {
                blocks = Arrays.asList(new MutableBlock[]{new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.OAK)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.SPRUCE)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.BIRCH)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.JUNGLE)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.ACACIA)), new MutableBlock(Blocks.SAPLING.getDefaultState().withProperty((IProperty)BlockSapling.TYPE, (Comparable)BlockPlanks.EnumType.DARK_OAK)), new MutableBlock(WitcheryWoodTypes.ROWAN.getSapling().getDefaultState()), new MutableBlock(WitcheryWoodTypes.ALDER.getSapling().getDefaultState()), new MutableBlock(WitcheryWoodTypes.HAWTHORN.getSapling().getDefaultState()), new MutableBlock(WitcheryBlocks.EMBER_MOSS.getDefaultState()), new MutableBlock(Blocks.TALLGRASS.getDefaultState().withProperty((IProperty)BlockTallGrass.TYPE, (Comparable)BlockTallGrass.EnumType.GRASS), 7), new MutableBlock(Blocks.TALLGRASS.getDefaultState().withProperty((IProperty)BlockTallGrass.TYPE, (Comparable)BlockTallGrass.EnumType.FERN), 7), new MutableBlock(Blocks.BROWN_MUSHROOM.getDefaultState()), new MutableBlock(Blocks.RED_MUSHROOM.getDefaultState()), new MutableBlock(Blocks.RED_FLOWER.getDefaultState()), new MutableBlock(Blocks.YELLOW_FLOWER.getDefaultState()), new MutableBlock(Blocks.PUMPKIN.getDefaultState()), new MutableBlock(Blocks.MELON_BLOCK.getDefaultState()), new MutableBlock(WitcheryBlocks.GLINT_WEED.getDefaultState())});
                ((MutableBlock)WeightedRandom.getRandomItem((Random)world.rand, blocks)).mutate(world, up, false);
            }
            if (world.rand.nextInt(3) == 0) {
                count = 0;
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)world, (BlockPos)up);
                sapling = above.getBlock();
                while ((sapling == Blocks.SAPLING || sapling instanceof WitcheryBlockSapling) && count++ < 8) {
                    ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)world, (BlockPos)up);
                    sapling = above.getBlock();
                }
            }
        }
    }
}

