/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockFetish;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.BlockUtil;

public class RiteEffectMovingEarth
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectMovingEarth> DESERIALIZER = json -> new RiteEffectMovingEarth(JsonUtils.getInt((JsonObject)json, (String)"radius"), JsonUtils.getInt((JsonObject)json, (String)"height", (int)8));
    private final int radius;
    private final int height;

    public RiteEffectMovingEarth(int radius, int height2) {
        this.radius = radius;
        this.height = height2;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.isRemote) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() == 1) {
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.PORTAL), world, pos);
        }
        int radius = this.radius + ritual.covenSize * 2;
        int AIR_SPACE = radius * 2;
        BlockPos depth = pos.up(AIR_SPACE);
        while (depth.getY() >= pos.getY() - this.height) {
            this.drawFilledCircle(world, depth, radius, depth.getY() == pos.getY() - 1);
            depth = depth.down();
        }
        AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-radius, 0, -radius), pos.add(radius, AIR_SPACE, radius));
        for (Entity entity : world.getEntitiesWithinAABB(Entity.class, bounds)) {
            if (!(entity.getDistanceSq(pos) <= (double)(radius * radius))) continue;
            if (entity instanceof EntityLivingBase) {
                entity.setPositionAndUpdate(entity.posX, entity.posY + 1.0, entity.posZ);
                continue;
            }
            entity.noClip = true;
            entity.setPosition(entity.posX, entity.posY + 1.0, entity.posZ);
            entity.noClip = false;
        }
        if (stage.get() < this.height - 1) {
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, boolean topLayer) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.add(-x, 0, z), pos.add(x, 0, z), topLayer, radius, pos.getZ());
            this.drawLine(world, pos.add(-z, 0, x), pos.add(z, 0, x), topLayer, radius, pos.getZ());
            this.drawLine(world, pos.add(-x, 0, -z), pos.add(x, 0, -z), topLayer, radius, pos.getZ());
            this.drawLine(world, pos.add(-z, 0, -x), pos.add(z, 0, -x), topLayer, radius, pos.getZ());
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, boolean topLayer, int radius, int midZ) {
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)x1, (BlockPos)x2)) {
            boolean edgeZ;
            IBlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            Block highBlock = world.getBlockState(pos.up()).getBlock();
            Block lowBlock = world.getBlockState(pos.down()).getBlock();
            if (block == Blocks.AIR || !BlockUtil.isMovableBlock(block) || !BlockUtil.isMovableBlock(highBlock) || !BlockUtil.isMovableBlock(lowBlock)) continue;
            boolean bl = edgeZ = midZ + radius == x1.getZ() || midZ - radius == x2.getZ();
            if (!topLayer && (edgeZ || pos.equals((Object)x1) || pos.equals((Object)x2)) && world.rand.nextInt(7) == 0) continue;
            if (block.hasTileEntity(state)) {
                TileEntity tileEntity = world.getTileEntity(pos);
                if (tileEntity == null || block instanceof BlockFetish && !((BlockFetish)block).isSpectral()) continue;
                world.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
                world.setBlockState(pos.up(), state, 2);
                world.setTileEntity(pos.up(), tileEntity);
                tileEntity.validate();
                continue;
            }
            world.setBlockState(pos.up(), state, 2);
            world.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
        }
    }

    @Override
    public int getRunTime() {
        return 5;
    }
}

