/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectManifestation
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectManifestation> DESERIALIZER = json -> new RiteEffectManifestation(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)5), JsonUtils.getInt((JsonObject)json, (String)"time", (int)125), JsonUtils.getInt((JsonObject)json, (String)"coven_member_bonus", (int)25));
    private final int radius;
    private final int time;
    private final int nbtCovenBonus;

    public RiteEffectManifestation(int radius, int value, int covenMemberBonus) {
        this.radius = radius;
        this.time = value;
        this.nbtCovenBonus = covenMemberBonus;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            int r = this.radius;
            AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-r, 0, -r), pos.add(r, 1, r));
            boolean bound = false;
            List boundPlayers = world.getEntitiesWithinAABB(EntityPlayer.class, bounds);
            for (EntityPlayer player : boundPlayers) {
                if (!(player.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)r)) continue;
                WitcheryUtils.getExtension(player).getSpiritData().setManifestationDuration(this.time + ritual.covenSize * this.nbtCovenBonus);
                bound = true;
            }
            if (!bound) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 3.0f, 3.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

