/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectItemSummoning
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectItemSummoning> DESERIALIZER = json -> {
        JsonElement particle;
        ArrayList<ItemRiteSacrifice.SummonedItemAction> actions = new ArrayList<ItemRiteSacrifice.SummonedItemAction>();
        JsonObject stack = json.getAsJsonObject("stack");
        JsonArray array = stack.getAsJsonArray("actions");
        if (array != null) {
            for (JsonElement element : array) {
                if (element.isJsonObject()) {
                    JsonObject jsonObject = element.getAsJsonObject();
                    Function1 serializer = (Function1)ItemRiteSacrifice.SummonedItemAction.DESERIALIZER_REGISTRY.get(new ResourceLocation(jsonObject.get("type").getAsString()));
                    actions.add((ItemRiteSacrifice.SummonedItemAction)serializer.invoke((Object)jsonObject));
                    continue;
                }
                Function1 serializer = (Function1)ItemRiteSacrifice.SummonedItemAction.DESERIALIZER_REGISTRY.get(new ResourceLocation(element.getAsString()));
                actions.add((ItemRiteSacrifice.SummonedItemAction)serializer.invoke((Object)new JsonObject()));
            }
        }
        EnumParticleTypes particles = (particle = json.get("particles")) == null ? EnumParticleTypes.SPELL : EnumParticleTypes.getByName((String)particle.getAsString());
        return new RiteEffectItemSummoning(WitcheryUtils.parseStack(stack), actions, particles == null ? EnumParticleTypes.SPELL : particles, JsonUtils.getFloat((JsonObject)json, (String)"particle_offset", (float)0.5f), JsonUtils.getFloat((JsonObject)json, (String)"position", (float)1.5f), JsonUtils.getFloat((JsonObject)json, (String)"motion", (float)0.3f));
    };
    private final ItemStack stack;
    private final List<ItemRiteSacrifice.SummonedItemAction> actions;
    private final EnumParticleTypes particles;
    private final float particleOffset;
    private final float position;
    private final float motion;

    public RiteEffectItemSummoning(ItemStack stack, List<ItemRiteSacrifice.SummonedItemAction> actions, EnumParticleTypes particles, float particleOffset, float position, float motion) {
        this.stack = stack;
        this.actions = actions;
        this.particles = particles;
        this.particleOffset = particleOffset;
        this.position = position;
        this.motion = motion;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            int failed = 0;
            ItemStack newStack = this.stack.copy();
            for (ItemRiteSacrifice.SummonedItemAction action : this.actions) {
                if (action.invoke(newStack, world, pos, ritual).booleanValue()) continue;
                ++failed;
            }
            if (!this.actions.isEmpty() && failed == this.actions.size()) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            EntityItem entity = new EntityItem(world, (double)pos.getX() + 0.5, (double)((float)pos.getY() + this.position), (double)pos.getZ() + 0.5, newStack);
            entity.motionY = this.motion;
            world.spawnEntity((Entity)entity);
            entity.world.playSound(null, entity.getPosition(), SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryUtils.addNewParticles(world, this.particles, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5, 0.0, Math.min(MathHelper.ceil((double)(Math.max((double)this.particleOffset, 1.0) * 20.0)), 300), this.particleOffset, this.particleOffset);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

