/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectInfusionRecharge
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectInfusionRecharge> DESERIALIZER = json -> new RiteEffectInfusionRecharge(JsonUtils.getInt((JsonObject)json, (String)"charges", (int)10), JsonUtils.getInt((JsonObject)json, (String)"radius", (int)4), JsonUtils.getFloat((JsonObject)json, (String)"upkeep_cost", (float)40.0f), JsonUtils.getInt((JsonObject)json, (String)"lifetime", (int)0));
    private final float upkeepPowerCost;
    private final int charges;
    private final int radius;
    private final int ticksToLive;

    public RiteEffectInfusionRecharge(int charges, int radius, float upkeepPowerCost, int ticksToLive) {
        this.charges = charges;
        this.radius = radius;
        this.upkeepPowerCost = upkeepPowerCost;
        this.ticksToLive = ticksToLive;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            if (this.upkeepPowerCost > 0.0f) {
                IPowerSource powerSource = this.findNewPowerSource(world, pos);
                if (powerSource == null) {
                    return RiteHandler.Result.ABORTED;
                }
                if (!powerSource.consumePower(this.upkeepPowerCost)) {
                    return RiteHandler.Result.ABORTED;
                }
            }
            if (this.ticksToLive > 0 && stage.incrementAndGet() >= this.ticksToLive) {
                return RiteHandler.Result.COMPLETED;
            }
            int r = this.radius;
            AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-r, 0, -r), pos.add(r, 1, r));
            for (EntityPlayer player : world.getEntitiesWithinAABB(EntityPlayer.class, bounds)) {
                int maxEnergy;
                int currentEnergy;
                if (!(player.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)r) || (currentEnergy = Infusion.getCurrentEnergy(player)) >= (maxEnergy = Infusion.getMaxEnergy(player))) continue;
                Infusion.setCurrentEnergy(player, Math.min(currentEnergy + this.charges, maxEnergy));
                player.world.playSound(null, player.getPosition(), SoundEvents.BLOCK_NOTE_PLING, SoundCategory.PLAYERS, 0.5f, 0.4f / (player.world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(player.posX, player.posY, player.posZ, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)player);
            }
        }
        return RiteHandler.Result.UPKEEP;
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }
}

