/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.infusion.Infusion;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectInfusePlayers
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectInfusePlayers> DESERIALIZER = json -> new RiteEffectInfusePlayers((Infusion)Infusion.REGISTRY.get(new ResourceLocation(JsonUtils.getString((JsonObject)json, (String)"infusion"))), JsonUtils.getInt((JsonObject)json, (String)"charges", (int)200), JsonUtils.getInt((JsonObject)json, (String)"radius", (int)4));
    private final Infusion infusion;
    private final int charges;
    private final int radius;

    public RiteEffectInfusePlayers(Infusion infusion, int charges, int radius) {
        this.infusion = infusion;
        this.charges = charges;
        this.radius = radius;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            int r = this.radius;
            AxisAlignedBB bounds = new AxisAlignedBB(pos.add(-r, 0, -r), pos.add(r, 1, r));
            for (EntityPlayer player : world.getEntitiesWithinAABB(EntityPlayer.class, bounds)) {
                if (!(player.getDistance((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= (double)r)) continue;
                player.attackEntityFrom(DamageSource.MAGIC, 100.0f);
                if (player.getHealth() <= 0.1f) continue;
                this.infusion.infuse(player, this.charges);
            }
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.PLAYERS, 0.5f, 0.4f / ((float)world.rand.nextDouble() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 3.0f, 3.0f, EnumParticleTypes.EXPLOSION_HUGE), world, pos);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

