/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.List;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.common.IPowerSource;
import net.msrandom.witchery.common.PowerSources;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityDemon;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectHellOnEarth
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectHellOnEarth> DESERIALIZER = json -> new RiteEffectHellOnEarth(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)20), JsonUtils.getInt((JsonObject)json, (String)"height", (int)15), JsonUtils.getFloat((JsonObject)json, (String)"power", (float)200.0f));
    private final float upkeepCost;

    public RiteEffectHellOnEarth(int radius, int height2, float upkeepCost) {
        super(radius, height2, true);
        this.upkeepCost = upkeepCost;
    }

    @Override
    public boolean isComplete(World world, BlockPos pos, int ticks, boolean fullyExpanded) {
        if (fullyExpanded && (long)ticks % 40L == 0L) {
            IPowerSource powerSource = this.findNewPowerSource(world, pos);
            if (powerSource == null) {
                return true;
            }
            if (!powerSource.consumePower(this.upkeepCost)) {
                return true;
            }
            double roll = world.rand.nextDouble();
            Object entity = roll < 0.02 ? new EntityDemon(world) : (roll < 0.1 ? new EntityGhast(world) : (roll < 0.4 ? new EntityBlaze(world) : (roll < 0.6 ? new EntityMagmaCube(world) : new EntityPigZombie(world))));
            entity.onInitialSpawn(world.getDifficultyForLocation(entity.getPosition()), null);
            entity.setLocationAndAngles((double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            world.spawnEntity((Entity)entity);
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_BLAZE_DEATH, entity.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 2.0, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.EXPLOSION_LARGE), world, pos.up(2));
        }
        return false;
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        return true;
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
        if (!world.isRemote) {
            IBlockState blockID = world.getBlockState(pos);
            IBlockState blockBelowID = world.getBlockState(pos.down());
            if (blockID.getBlock() == Blocks.TALLGRASS) {
                if (WitcheryConfigOptions.allowHellOnEarthFires && enhanced) {
                    world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                }
                this.blightGround(world, pos.down(), blockBelowID.getBlock(), currentRadius);
            } else if (blockID.getBlock() == Blocks.RED_FLOWER || blockID.getBlock() == Blocks.YELLOW_FLOWER || blockID.getBlock() == Blocks.CARROTS || blockID.getBlock() == Blocks.WHEAT || blockID.getBlock() == Blocks.POTATOES || blockID.getBlock() == Blocks.PUMPKIN_STEM || blockID.getBlock() == Blocks.MELON_STEM || blockID.getBlock() == Blocks.MELON_BLOCK || blockID.getBlock() == Blocks.PUMPKIN) {
                if (WitcheryConfigOptions.allowHellOnEarthFires && enhanced) {
                    world.setBlockState(pos, Blocks.FIRE.getDefaultState());
                }
                this.blightGround(world, pos.down(), blockBelowID.getBlock(), currentRadius);
            } else if (blockID.getMaterial().isSolid()) {
                this.blightGround(world, pos, blockID.getBlock(), currentRadius);
            } else if (blockBelowID.getMaterial().isSolid()) {
                this.blightGround(world, pos.down(), blockBelowID.getBlock(), currentRadius);
            }
        }
    }

    public void blightGround(World world, BlockPos pos, Block blockBelowID, int currentRadius) {
        int rand;
        if ((blockBelowID == Blocks.DIRT || blockBelowID == Blocks.GRASS || blockBelowID == Blocks.MYCELIUM || blockBelowID == Blocks.FARMLAND || blockBelowID == Blocks.SAND) && (rand = world.rand.nextInt(currentRadius < this.maxRadius / 3 ? 2 : (currentRadius < this.maxRadius / 2 ? 4 : 6))) == 0) {
            world.setBlockState(pos, Blocks.NETHERRACK.getDefaultState());
        }
    }

    private IPowerSource findNewPowerSource(World world, BlockPos pos) {
        List<PowerSources.RelativePowerSource> sources = PowerSources.instance().get(world, pos);
        return sources != null && sources.size() > 0 ? sources.get(0).source() : null;
    }
}

