/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockCircleGlyph;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectGlyphicTransformation
extends RiteEffect {
    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            double RADIUS = 4.0;
            List items = world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(pos.add(-RADIUS, -2.0, -RADIUS), pos.add(RADIUS, 2.0, RADIUS)));
            int whiteChalk = 0;
            int purpleChalk = 0;
            int redChalk = 0;
            for (EntityItem item : items) {
                boolean first;
                ItemStack stack = item.getItem();
                if (redChalk == 0 && purpleChalk == 0 && stack.isItemEqual(new ItemStack((Block)WitcheryBlocks.GLYPH_RITUAL))) {
                    first = whiteChalk == 0;
                    whiteChalk += stack.getCount();
                    if (first) {
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            world.removeEntity((Entity)item);
                        }
                    }
                } else if (redChalk == 0 && whiteChalk == 0 && stack.isItemEqual(new ItemStack((Block)WitcheryBlocks.GLYPH_OTHERWHERE))) {
                    first = purpleChalk == 0;
                    purpleChalk += stack.getCount();
                    if (first) {
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            world.removeEntity((Entity)item);
                        }
                    }
                } else {
                    if (purpleChalk != 0 || whiteChalk != 0 || !stack.isItemEqual(new ItemStack((Block)WitcheryBlocks.GLYPH_INFERNAL))) continue;
                    first = redChalk == 0;
                    redChalk += stack.getCount();
                    if (first) {
                        stack.shrink(1);
                        if (stack.isEmpty()) {
                            world.removeEntity((Entity)item);
                        }
                    }
                }
                world.playSound(null, item.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(item.posX, item.posY, item.posZ, 1.0f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), (Entity)item);
            }
            Block blockID = Blocks.AIR;
            int size = 0;
            if (whiteChalk == 0 && redChalk == 0 && purpleChalk == 0) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (redChalk > 0) {
                blockID = WitcheryBlocks.GLYPH_INFERNAL;
                size = Math.min(redChalk, 3);
            } else if (purpleChalk > 0) {
                blockID = WitcheryBlocks.GLYPH_OTHERWHERE;
                size = Math.min(purpleChalk, 3);
            } else if (whiteChalk > 0) {
                blockID = WitcheryBlocks.GLYPH_RITUAL;
                size = Math.min(whiteChalk, 3);
            }
            int a = 1;
            int b = 2;
            int c = 3;
            int d = 0;
            int[][] PATTERN = new int[][]{{d, d, d, d, d, d, d, d, d, d, d, d, d, d, d, d, d}, {d, d, d, d, d, c, c, c, c, c, c, c, d, d, d, d, d}, {d, d, d, d, c, d, d, d, d, d, d, d, c, d, d, d, d}, {d, d, d, c, d, d, b, b, b, b, b, d, d, c, d, d, d}, {d, d, c, d, d, b, d, d, d, d, d, b, d, d, c, d, d}, {d, c, d, d, b, d, d, a, a, a, d, d, b, d, d, c, d}, {d, c, d, b, d, d, a, d, d, d, a, d, d, b, d, c, d}, {d, c, d, b, d, a, d, d, d, d, d, a, d, b, d, c, d}, {d, c, d, b, d, a, d, d, 4, d, d, a, d, b, d, c, d}, {d, c, d, b, d, a, d, d, d, d, d, a, d, b, d, c, d}, {d, c, d, b, d, d, a, d, d, d, a, d, d, b, d, c, d}, {d, c, d, d, b, d, d, a, a, a, d, d, b, d, d, c, d}, {d, d, c, d, d, b, d, d, d, d, d, b, d, d, c, d, d}, {d, d, d, c, d, d, b, b, b, b, b, d, d, c, d, d, d}, {d, d, d, d, c, d, d, d, d, d, d, d, c, d, d, d, d}, {d, d, d, d, d, c, c, c, c, c, c, c, d, d, d, d, d}, {d, d, d, d, d, d, d, d, d, d, d, d, d, d, d, d, d}};
            for (int z = 0; z < PATTERN.length - 1; ++z) {
                int offsetX = (PATTERN[z].length - 1) / 2;
                for (int x = 0; x < PATTERN[z].length; ++x) {
                    BlockPos offset;
                    IBlockState state;
                    Block currentBlockID;
                    int item2 = PATTERN[PATTERN.length - 1 - z][x];
                    if (item2 != size || (currentBlockID = (state = world.getBlockState(offset = pos.add(x - offsetX, 0, z - offsetX))).getBlock()) != WitcheryBlocks.GLYPH_INFERNAL && currentBlockID != WitcheryBlocks.GLYPH_OTHERWHERE && currentBlockID != WitcheryBlocks.GLYPH_RITUAL || currentBlockID == blockID) continue;
                    world.setBlockState(offset, blockID.getDefaultState().withProperty(BlockCircleGlyph.GLYPH, state.getValue(BlockCircleGlyph.GLYPH)), 3);
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)offset.getX() + 0.5, (double)(offset.getY() + 1), (double)offset.getZ() + 0.5, 0.5f, 1.0f, EnumParticleTypes.SMOKE_NORMAL), world, offset.up());
                }
            }
        }
        return RiteHandler.Result.COMPLETED;
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

