/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.WitcheryBlockSapling;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.util.MutableBlock;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectForestation
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectForestation> DESERIALIZER = json -> new RiteEffectForestation(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)20), JsonUtils.getInt((JsonObject)json, (String)"height", (int)8), JsonUtils.getInt((JsonObject)json, (String)"duration", (int)60), WitcheryUtils.parseBlockState(json.get("state").getAsString()));
    private final int radius;
    private final int height;
    private final int duration;
    private final IBlockState state;

    public RiteEffectForestation(int radius, int height2, int duration, IBlockState state) {
        this.radius = radius;
        this.height = height2;
        this.duration = duration;
        this.state = state;
    }

    public boolean isAirOrReplaceableBlock(World world, BlockPos pos) {
        IBlockState blockID = world.getBlockState(pos);
        if (blockID.getBlock() == Blocks.AIR) {
            return true;
        }
        Material block = blockID.getMaterial();
        return !block.isLiquid() && block.isReplaceable();
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (world.isRemote) {
            return RiteHandler.Result.COMPLETED;
        }
        if (stage.incrementAndGet() < this.duration + ritual.covenSize * 5) {
            int modradius = this.radius + ritual.covenSize * 2;
            int modradiussq = (modradius + 1) * (modradius + 1);
            pos = pos.down();
            BlockPos p = pos.add(world.rand.nextInt(modradius * 2) - modradius, 0, world.rand.nextInt(modradius * 2) - modradius);
            int height2 = -1;
            if (p.distanceSq((double)pos.getX(), (double)p.getY(), (double)pos.getZ()) > (double)modradiussq && (p = pos.add(world.rand.nextInt(modradius * 2) - modradius, 0, world.rand.nextInt(modradius * 2) - modradius)).distanceSq((double)pos.getX(), (double)p.getY(), (double)pos.getZ()) > (double)modradiussq) {
                return RiteHandler.Result.UPKEEP;
            }
            world.playEvent(2005, p.up(2), 0);
            Material material = world.getBlockState(p).getMaterial();
            if (!material.isSolid() || !world.isAirBlock(p.up())) {
                for (int h = 1; h < this.height; ++h) {
                    material = world.getBlockState(p.up(h)).getMaterial();
                    if (material.isSolid() && this.isAirOrReplaceableBlock(world, p.up(h + 1))) {
                        height2 = h;
                    } else {
                        material = world.getBlockState(p.down(h)).getMaterial();
                        if (!material.isSolid() || !this.isAirOrReplaceableBlock(world, pos.down(h - 1))) continue;
                        height2 = -h;
                    }
                    break;
                }
            } else {
                height2 = 0;
            }
            if (height2 != -1) {
                world.playEvent(2005, p.up(height2 + 1), 0);
                this.drawPixel(world, p.up(height2 + 1), this.state);
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.COMPLETED;
    }

    protected void drawPixel(World world, BlockPos pos, IBlockState state) {
        Material materialAbove = world.getBlockState(pos).getMaterial();
        if (!materialAbove.isSolid()) {
            new MutableBlock(state).mutate(world, pos, false);
            int count = 0;
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)world, (BlockPos)pos);
            Block sapling2 = world.getBlockState(pos).getBlock();
            while ((sapling2 == Blocks.SAPLING || sapling2 instanceof WitcheryBlockSapling) && count++ < 10) {
                ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)world, (BlockPos)pos);
                sapling2 = world.getBlockState(pos).getBlock();
            }
        }
    }
}

