/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectFertility
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectFertility> DESERIALIZER = json -> new RiteEffectFertility(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)50), JsonUtils.getInt((JsonObject)json, (String)"height", (int)15));

    public RiteEffectFertility(int radius, int height2) {
        super(radius, height2, false);
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
        Block blockID = world.getBlockState(pos).getBlock();
        if ((blockID != Blocks.DIRT && blockID != Blocks.GRASS && blockID != Blocks.MYCELIUM && blockID != Blocks.FARMLAND || world.rand.nextInt(5) == 0) && player != null) {
            ItemDye.applyBonemeal((ItemStack)new ItemStack(Items.DYE, 1, EnumDyeColor.WHITE.getDyeDamage()), (World)world, (BlockPos)pos, (EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND);
        }
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (EntityPlayer victim : world.playerEntities) {
            double d = victim.getDistanceSq(pos);
            if (!(d > minSq) || !(d <= radiusSq)) continue;
            if (victim.isPotionActive(MobEffects.NAUSEA)) {
                victim.removePotionEffect(MobEffects.NAUSEA);
            }
            if (victim.isPotionActive(MobEffects.BLINDNESS)) {
                victim.removePotionEffect(MobEffects.BLINDNESS);
            }
            if (victim.isPotionActive(MobEffects.POISON)) {
                victim.removePotionEffect(MobEffects.POISON);
            }
            if (!enhanced) continue;
            victim.addPotionEffect(new PotionEffect(MobEffects.REGENERATION, 300, 1));
            victim.addPotionEffect(new PotionEffect(MobEffects.SATURATION, 2400));
        }
        ArrayList<EntityZombieVillager> villagersToZombify = new ArrayList<EntityZombieVillager>();
        for (Entity entity : world.loadedEntityList) {
            EntityZombieVillager victim2;
            double distanceSq2;
            if (!(entity instanceof EntityZombieVillager) || (distanceSq2 = (victim2 = (EntityZombieVillager)entity).getDistanceSq(pos)) <= minSq || distanceSq2 > radiusSq) continue;
            villagersToZombify.add(victim2);
        }
        for (EntityZombie entityZombie : villagersToZombify) {
            EntityVillager entityvillager = new EntityVillager(world);
            entityvillager.copyLocationAndAnglesFrom((Entity)entityZombie);
            entityvillager.onInitialSpawn(world.getDifficultyForLocation(entityZombie.getPosition()), null);
            entityvillager.setLookingForHome();
            if (entityZombie.isChild()) {
                entityvillager.setGrowingAge(-24000);
            }
            world.removeEntity((Entity)entityZombie);
            world.spawnEntity((Entity)entityvillager);
            entityvillager.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 200, 0));
            world.playEvent(1017, entityvillager.getPos(), 0);
        }
        return true;
    }
}

