/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public abstract class RiteEffectExpandingEffect
extends RiteEffect {
    protected final int maxRadius;
    protected final int height;
    protected final boolean curse;

    public RiteEffectExpandingEffect(int radius, int height2, boolean curse) {
        this.maxRadius = radius;
        this.height = height2;
        this.curse = curse;
    }

    public abstract void doBlockAction(World var1, BlockPos var2, int var3, EntityPlayer var4, boolean var5);

    public abstract boolean doRadiusAction(World var1, BlockPos var2, int var3, EntityPlayer var4, boolean var5);

    public boolean isComplete(World world, BlockPos pos, int ticks, boolean fullyExpanded) {
        return fullyExpanded;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        boolean enhanced;
        if (ticks < 20) {
            return RiteHandler.Result.STARTING;
        }
        if (ticks == 20) {
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        }
        if (world.isRemote) {
            return RiteHandler.Result.COMPLETED;
        }
        if ((long)ticks % 5L != 0L) {
            return RiteHandler.Result.UPKEEP;
        }
        stage.incrementAndGet();
        if (stage.get() == 1 && this.curse) {
            EntityWitchHunter.blackMagicPerformed(ritual.getInitiatingPlayer(world));
        }
        float maxRadius = this.maxRadius + 2 * ritual.covenSize;
        EntityPlayer player = ritual.getInitiatingPlayer(world);
        int currentRadius = stage.get() + 3;
        boolean bl = enhanced = player != null && Familiars.hasFamiliarPower(player, WitcheryFamiliars.CURSE_MASTERY);
        if ((float)currentRadius <= maxRadius && !this.applyCircle(world, pos, currentRadius, this.height, player, enhanced)) {
            return RiteHandler.Result.ABORTED;
        }
        return stage.get() > 250 || this.isComplete(world, pos, ticks, (float)currentRadius >= maxRadius) ? RiteHandler.Result.COMPLETED : RiteHandler.Result.UPKEEP;
    }

    protected boolean applyCircle(World world, BlockPos pos, int radius, int height2, EntityPlayer player, boolean enhanced) {
        if (!this.doRadiusAction(world, pos, radius, player, enhanced)) {
            return false;
        }
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawPixel(world, pos.add(x, 0, z), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(z, 0, x), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(-x, 0, z), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(-z, 0, x), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(-x, 0, -z), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(-z, 0, -x), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(x, 0, -z), height2, radius, player, enhanced);
            this.drawPixel(world, pos.add(z, 0, -x), height2, radius, player, enhanced);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
        return true;
    }

    protected void drawPixel(World world, BlockPos pos, int height2, int currentRadius, EntityPlayer player, boolean enhanced) {
        for (int i = 0; i < height2; ++i) {
            if (world.getBlockState(pos.up(i)).getMaterial() != Material.AIR && world.isAirBlock(pos.up(i + 1))) {
                if (this.curse) {
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() + i + 1), (double)pos.getZ() + 0.5, 1.0f, 1.0f, EnumParticleTypes.SPELL_MOB), world, pos.up(i + 1));
                } else {
                    WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() + i + 1), (double)pos.getZ() + 0.5, 1.0f, 1.0f, EnumParticleTypes.SPELL), world, pos.up(i + 1));
                }
                this.doBlockAction(world, pos.up(i), currentRadius, player, enhanced);
                break;
            }
            if (i <= 0 || world.getBlockState(pos.down(i)).getMaterial() == Material.AIR || !world.isAirBlock(pos.down(i - 1))) continue;
            if (this.curse) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() - i + 1), (double)pos.getZ() + 0.5, 1.0f, 1.0f, EnumParticleTypes.SPELL_MOB), world, pos.down(i - 1), 32.0);
            } else {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)(pos.getY() - i + 1), (double)pos.getZ() + 0.5, 1.0f, 1.0f, EnumParticleTypes.SPELL), world, pos.down(i - 1), 32.0);
            }
            this.doBlockAction(world, pos.down(i), currentRadius, player, enhanced);
            break;
        }
    }
}

