/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectEclipse
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectEclipse> DESERIALIZER = json -> new RiteEffectEclipse(JsonUtils.getInt((JsonObject)json, (String)"cooldown", (int)0));
    private static final Object2LongMap<DimensionType> lastEclipseTimes = new Object2LongOpenHashMap();
    private final int cooldown;

    public RiteEffectEclipse(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            EntityPlayer player = ritual.getInitiatingPlayer(world);
            DimensionType dimensionType = world.provider.getDimensionType();
            if ((long)this.cooldown > 0L && world.playerEntities.size() > 1 && lastEclipseTimes.containsKey((Object)dimensionType)) {
                long lastActivation = lastEclipseTimes.getLong((Object)dimensionType);
                if (world.getTotalWorldTime() < lastActivation + (long)this.cooldown) {
                    if (player != null) {
                        player.sendMessage(new TextComponentTranslation("rite.witchery.eclipse.cooldown", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
            }
            long i = world.getWorldInfo().getWorldTime();
            world.getWorldInfo().setWorldTime(i - i % 24000L + 18000L);
            lastEclipseTimes.put((Object)dimensionType, world.getTotalWorldTime());
        }
        return RiteHandler.Result.COMPLETED;
    }

    @Override
    public int getRunTime() {
        return 30;
    }
}

