/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;

public class RiteEffectCursePoppets
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectCursePoppets> DESERIALIZER = json -> new RiteEffectCursePoppets(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()));
    private final long target;

    public RiteEffectCursePoppets(long target) {
        this.target = target;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            RiteEffect.SacrificedItem sacrificedItem;
            boolean curseMaster;
            boolean complete = false;
            EntityPlayer curseMasterPlayer = ritual.getInitiatingPlayer(world);
            boolean bl = curseMaster = curseMasterPlayer != null && Familiars.hasFamiliarPower(curseMasterPlayer, WitcheryFamiliars.CURSE_MASTERY);
            if (curseMaster && (sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target)) != null) {
                EntityLivingBase entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0);
                if (entity != null && !WitcheryPoppetItems.poppetProtectionActivated(curseMasterPlayer, ItemStack.EMPTY, entity, true)) {
                    WitcheryPoppetItems.destroyAntiVoodooPoppets(entity, 10);
                }
                complete = true;
            }
            if (curseMasterPlayer != null) {
                curseMasterPlayer.sendMessage((ITextComponent)new TextComponentTranslation("rite.witchery.no_curse_mastery", new Object[0]));
            }
            if (!complete) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_ENDERDRAGON_GROWL, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

