/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.entity.EntityWereVillager;
import net.msrandom.witchery.entity.EntityWerewolf;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.PlayerExtendedData;
import net.msrandom.witchery.init.WitcheryTransformations;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;
import net.msrandom.witchery.transformation.WerewolfTransformation;
import net.msrandom.witchery.util.CreatureUtil;
import net.msrandom.witchery.util.WitcheryUtils;

public class RiteEffectCurseOfTheWolf
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectCurseOfTheWolf> DESERIALIZER = json -> new RiteEffectCurseOfTheWolf(ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()), !json.get("remove").getAsBoolean());
    private final long target;
    private final boolean curse;

    public RiteEffectCurseOfTheWolf(long target, boolean curse) {
        this.target = target;
        this.curse = curse;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            EntityLivingBase entity;
            boolean complete = false;
            boolean cursed = false;
            EntityPlayer curseMasterPlayer = ritual.getInitiatingPlayer(world);
            if (!CreatureUtil.isFullMoon(world)) {
                curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.not_full_moon", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (!Familiars.hasFamiliarPower(curseMasterPlayer, WitcheryFamiliars.CURSE_MASTERY)) {
                curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.no_curse_mastery", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (ritual.covenSize < 6) {
                curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.coven_not_full", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target);
            if (sacrificedItem != null && (entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0)) != null) {
                if (this.curse) {
                    EntityWitchHunter.blackMagicPerformed(curseMasterPlayer);
                    boolean isImmune = ItemHunterClothes.isCurseProtectionActive(entity);
                    if (!isImmune) {
                        isImmune = BlockAreaMarker.AreaMarkerRegistry.instance().isProtectionActive(entity, this);
                    }
                    if (!isImmune && !WitcheryPoppetItems.voodooProtectionActivated(curseMasterPlayer, ItemStack.EMPTY, entity, 3)) {
                        if (entity instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)entity;
                            PlayerExtendedData playerEx = WitcheryUtils.getExtension(player);
                            if (!WitcheryConfigOptions.allowVampireWolfHybrids && playerEx.isTransformation(WitcheryTransformations.VAMPIRE)) {
                                curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.hybridsnotallow", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                            } else {
                                WerewolfTransformation transformation = playerEx.getTransformation(WitcheryTransformations.WEREWOLF);
                                if (transformation.getLevel() == 0) {
                                    transformation.setLevel(1);
                                    playerEx.sync();
                                    player.sendMessage(new TextComponentTranslation("witchery.werewolf.infection", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_PURPLE)));
                                    complete = true;
                                    cursed = true;
                                } else {
                                    curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.already_cursed", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                                }
                            }
                        } else if (entity instanceof EntityVillager && !(entity instanceof EntityWereVillager)) {
                            EntityVillager villager = (EntityVillager)entity;
                            NBTTagCompound data = new NBTTagCompound();
                            villager.writeEntityToNBT(data);
                            EntityWerewolf.convertToVillager((EntityLiving)villager, data, true);
                            complete = true;
                            cursed = true;
                        } else {
                            curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.different_creature", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                        }
                    }
                    if (isImmune && curseMasterPlayer != null) {
                        curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.magic_dissipating", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    }
                } else if (entity instanceof EntityPlayer) {
                    EntityPlayer player2 = (EntityPlayer)entity;
                    PlayerExtendedData playerEx2 = WitcheryUtils.getExtension(player2);
                    WerewolfTransformation transformation = playerEx2.getTransformation(WitcheryTransformations.WEREWOLF);
                    if (transformation.getLevel() > 0) {
                        double MAX_RANGE_SQ = 64.0;
                        if (transformation.getLevel() == 1 || player2.getDistanceSq(pos) <= MAX_RANGE_SQ) {
                            if (world.rand.nextInt(4) != 0) {
                                transformation.setLevel(0);
                                playerEx2.sync();
                            } else {
                                cursed = true;
                            }
                            complete = true;
                        } else {
                            curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.too_far", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                        }
                    } else {
                        curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    }
                } else if (entity instanceof EntityWereVillager) {
                    EntityWereVillager villagerWere = (EntityWereVillager)entity;
                    EntityWerewolf.convertToCuredVillager((EntityLiving)villagerWere, villagerWere.getVillagerData());
                    complete = true;
                } else if (entity instanceof EntityWerewolf) {
                    EntityWerewolf werewolf = (EntityWerewolf)entity;
                    EntityWerewolf.convertToCuredVillager((EntityLiving)werewolf, werewolf.getVillagerData());
                    complete = true;
                } else {
                    curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.wolf_curse.not_cursed", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                }
            }
            if (!complete) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (cursed) {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_ENDERDRAGON_GROWL, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
            } else {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), world, pos);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }
}

