/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.msrandom.witchery.block.BlockAreaMarker;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.entity.EntityWitchHunter;
import net.msrandom.witchery.entity.familiar.Familiars;
import net.msrandom.witchery.extensions.LivingExtendedData;
import net.msrandom.witchery.init.WitcheryDataExtensions;
import net.msrandom.witchery.init.data.WitcheryFamiliars;
import net.msrandom.witchery.item.ItemHunterClothes;
import net.msrandom.witchery.item.ItemTaglockKit;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.curse.Curse;
import net.msrandom.witchery.rite.effect.RiteEffect;
import net.msrandom.witchery.rite.sacrifice.ItemRiteSacrifice;

public class RiteEffectCurseCreature
extends RiteEffect {
    private final boolean curse;
    private final long target;
    private final int level;
    private final Curse curseType;
    private final boolean hunterArmorProtection;

    public RiteEffectCurseCreature(boolean curse, long target, Curse curseType, int level, boolean hunterArmorProtection) {
        this.curse = curse;
        this.target = target;
        this.level = level;
        this.curseType = curseType;
        this.hunterArmorProtection = hunterArmorProtection;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            EntityLivingBase entity;
            int levelBuff;
            boolean complete = false;
            boolean cursed = false;
            EntityPlayer curseMasterPlayer = ritual.getInitiatingPlayer(world);
            int n = levelBuff = curseMasterPlayer != null && Familiars.hasFamiliarPower(curseMasterPlayer, WitcheryFamiliars.CURSE_MASTERY) ? 1 : 0;
            if (ritual.covenSize == 6) {
                levelBuff += 2;
            } else if (ritual.covenSize >= 3) {
                ++levelBuff;
            }
            RiteEffect.SacrificedItem sacrificedItem = (RiteEffect.SacrificedItem)ritual.sacrificedItems.get(this.target);
            if (sacrificedItem != null && (entity = ItemTaglockKit.getBoundEntity(world, sacrificedItem.getStack(), 0)) != null) {
                LivingExtendedData livingEx = WitcheryDataExtensions.LIVING.get(entity);
                int currentLevel = livingEx.getCurses().getInt((Object)livingEx);
                if (this.curse) {
                    boolean isImmune;
                    EntityWitchHunter.blackMagicPerformed(curseMasterPlayer);
                    boolean bl = isImmune = this.hunterArmorProtection && ItemHunterClothes.isCurseProtectionActive(entity);
                    if (!isImmune) {
                        isImmune = BlockAreaMarker.AreaMarkerRegistry.instance().isProtectionActive(entity, this);
                    }
                    if (!isImmune && !WitcheryPoppetItems.voodooProtectionActivated(curseMasterPlayer, null, entity, levelBuff > 0 ? 3 : 1)) {
                        livingEx.getCurses().put((Object)this.curseType, Math.max(this.level + levelBuff, currentLevel));
                        cursed = true;
                        if (entity instanceof EntityPlayer) {
                            livingEx.syncCurses();
                        }
                    }
                    if (isImmune) {
                        if (curseMasterPlayer != null) {
                            curseMasterPlayer.sendMessage(new TextComponentTranslation("rite.witchery.magic_dissipating", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                        }
                    } else {
                        complete = true;
                    }
                } else {
                    int newLevel = 0;
                    if (currentLevel > 0) {
                        if (this.level + levelBuff > currentLevel) {
                            newLevel = world.rand.nextInt(20) == 0 ? currentLevel + 1 : 0;
                        } else if (this.level + levelBuff < currentLevel) {
                            newLevel = world.rand.nextInt(4) == 0 ? 0 : currentLevel + 1;
                        } else {
                            int n2 = newLevel = world.rand.nextInt(4) == 0 ? currentLevel + 1 : 0;
                        }
                    }
                    if (newLevel == 0) {
                        livingEx.getCurses().removeInt((Object)this.curseType);
                        if (entity.isPotionActive(MobEffects.POISON)) {
                            entity.removePotionEffect(MobEffects.POISON);
                        }
                        if (entity.isPotionActive(MobEffects.WEAKNESS)) {
                            entity.removePotionEffect(MobEffects.WEAKNESS);
                        }
                        if (entity.isPotionActive(MobEffects.BLINDNESS)) {
                            entity.removePotionEffect(MobEffects.BLINDNESS);
                        }
                        if (entity.isPotionActive(MobEffects.MINING_FATIGUE)) {
                            entity.removePotionEffect(MobEffects.MINING_FATIGUE);
                        }
                        if (entity.isPotionActive(MobEffects.SLOWNESS)) {
                            entity.removePotionEffect(MobEffects.SLOWNESS);
                        }
                    } else {
                        livingEx.getCurses().put((Object)this.curseType, newLevel);
                        cursed = true;
                    }
                    if (entity instanceof EntityPlayer) {
                        livingEx.syncCurses();
                    }
                    complete = true;
                }
            }
            if (!complete) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            if (cursed) {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_ENDERDRAGON_GROWL, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.FLAME), world, pos, 16.0);
            } else {
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, SoundEvents.ENTITY_PLAYER_LEVELUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5, 1.0f, 2.0f, EnumParticleTypes.SPELL_INSTANT), world, pos, 16.0);
            }
        }
        return RiteHandler.Result.COMPLETED;
    }

    public static Function1<JsonObject, RiteEffectCurseCreature> getDeserializer(boolean remove) {
        return json -> {
            JsonElement level = json.get("level");
            JsonElement hunterArmorProtection = json.get("hunter_armor_protection");
            return new RiteEffectCurseCreature(!remove, ItemRiteSacrifice.parseIdentifier(json.get("target").getAsString()), (Curse)Curse.REGISTRY.get(new ResourceLocation(json.get("curse").getAsString())), level == null ? 1 : level.getAsInt(), !remove && hunterArmorProtection != null && hunterArmorProtection.getAsBoolean());
        };
    }
}

