/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChunkData;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.brewing.ItemKey;
import net.msrandom.witchery.config.WitcheryConfigOptions;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectClimateChange
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectClimateChange> DESERIALIZER = json -> new RiteEffectClimateChange(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)16));
    public static final BiMap<ItemKey, BiomeDictionary.Type> FOCIS = HashBiMap.create();
    protected final int radius;

    public RiteEffectClimateChange(int radius) {
        this.radius = radius;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (ticks < 20) {
            return RiteHandler.Result.STARTING;
        }
        if (ticks == 20) {
            world.playSound(null, pos, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
        }
        if (world.isRemote) {
            return RiteHandler.Result.COMPLETED;
        }
        EntityPlayer player = ritual.getInitiatingPlayer(world);
        if (!WitcheryConfigOptions.allowBiomeChanging) {
            world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.disabled", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        Biome biome = world.getBiomeForCoordsBody(pos);
        if (world.provider.getDimension() == 1 || world.provider.getDimension() == -1 || biome == Biomes.SKY || biome == Biomes.HELL) {
            world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.invalid_dimension", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if (ritual.covenSize < 4) {
            world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            if (player != null) {
                player.sendMessage(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
            }
            return RiteHandler.Result.ABORTED_REFUND;
        }
        if ((long)ticks % 20L == 0L) {
            if (stage.incrementAndGet() < 5) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)pos.getZ() + 0.5, (float)stage.get() * 2.0f, (float)stage.get() * 1.1f, EnumParticleTypes.SPELL_INSTANT), world, pos.up(), 16.0);
            } else if (stage.get() == 5) {
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)pos.getZ() + 0.5, (float)stage.get() * 2.0f, (float)stage.get() * 1.5f, EnumParticleTypes.EXPLOSION_HUGE), world, pos.up(), 16.0);
                double RADIUS = 8.0;
                List items = world.getEntitiesWithinAABB(EntityItem.class, new AxisAlignedBB(pos.add(-RADIUS, -2.0, -RADIUS), pos.add(RADIUS, 2.0, RADIUS)));
                BiomeDictionary.Type biomeType = BiomeDictionary.Type.END;
                WeatherChange weather = WeatherChange.NONE;
                int glowstone = 0;
                for (EntityItem item : items) {
                    ItemStack stack = item.getItem();
                    BiomeDictionary.Type type = (BiomeDictionary.Type)FOCIS.get((Object)ItemKey.fromStack(stack));
                    if (type == null) {
                        if (stack.getItem() != Items.GLOWSTONE_DUST) continue;
                        glowstone += stack.getCount();
                    } else {
                        if (type == BiomeDictionary.Type.SNOWY) {
                            weather = WeatherChange.RAIN;
                        } else if (type == BiomeDictionary.Type.SANDY) {
                            weather = WeatherChange.SUN;
                        } else if (type == BiomeDictionary.Type.OCEAN) {
                            weather = WeatherChange.THUNDER;
                        }
                        biomeType = type;
                    }
                    world.removeEntity((Entity)item);
                    item.world.playSound(null, item.getPosition(), SoundEvents.ENTITY_ITEM_PICKUP, SoundCategory.PLAYERS, 0.5f, 0.4f / (item.world.rand.nextFloat() * 0.4f + 0.8f));
                    WitcheryNetworkChannel.sendToAllTracking(new PacketParticles(item.posX, item.posY, item.posZ, 0.5f, 1.0f, EnumParticleTypes.SPELL_INSTANT), (Entity)item);
                }
                if (biomeType == BiomeDictionary.Type.END) {
                    world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    if (player != null) {
                        player.sendMessage(new TextComponentTranslation("rite.witchery.no_biome_foci", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                List biomes = CollectionsKt.sortedWith((Iterable)BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType), Comparator.comparingInt(Biome::getIdForBiome));
                if (biomes.isEmpty()) {
                    world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, SoundCategory.BLOCKS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                    if (player != null) {
                        player.sendMessage(new TextComponentTranslation("rite.witchery.no_biome_foci", new Object[0]).setStyle(new Style().setColor(TextFormatting.DARK_RED)));
                    }
                    return RiteHandler.Result.ABORTED_REFUND;
                }
                int biomeID = Biome.getIdForBiome((Biome)((Biome)biomes.get(glowstone > 0 ? Math.min(glowstone, biomes.size()) - 1 : (biomes.size() >= 3 ? world.rand.nextInt(3) : 0))));
                int maxRadius = this.radius * (ritual.covenSize - 3);
                HashMap<ChunkPos, byte[]> chunkMap = new HashMap<ChunkPos, byte[]>();
                this.drawFilledCircle(world, pos, maxRadius, chunkMap, weather, biomeID);
                for (Map.Entry<ChunkPos, byte[]> entry2 : chunkMap.entrySet()) {
                    Chunk chunk = world.getChunk(entry2.getKey().x, entry2.getKey().z);
                    chunk.setBiomeArray(entry2.getValue());
                    chunk.markDirty();
                    SPacketChunkData packet2 = new SPacketChunkData(chunk, 65535);
                    for (EntityPlayer playerEntity : world.playerEntities) {
                        ((EntityPlayerMP)playerEntity).connection.sendPacket((Packet)packet2);
                    }
                }
                if (world instanceof WorldServer) {
                    WorldInfo worldinfo = world.getWorldInfo();
                    int i = (300 + world.rand.nextInt(600)) * 20;
                    switch (weather) {
                        case SUN: {
                            if (!world.isRaining() && !world.isThundering()) break;
                            worldinfo.setRainTime(0);
                            worldinfo.setThunderTime(0);
                            worldinfo.setRaining(false);
                            worldinfo.setThundering(false);
                            break;
                        }
                        case RAIN: {
                            if (world.isRaining() || world.isThundering()) break;
                            worldinfo.setRainTime(i);
                            worldinfo.setThunderTime(i);
                            worldinfo.setRaining(true);
                            worldinfo.setThundering(false);
                            break;
                        }
                        case THUNDER: {
                            if (world.isThundering()) break;
                            worldinfo.setRainTime(i);
                            worldinfo.setThunderTime(i);
                            worldinfo.setRaining(true);
                            worldinfo.setThundering(true);
                        }
                    }
                }
                return RiteHandler.Result.COMPLETED;
            }
            return RiteHandler.Result.UPKEEP;
        }
        return RiteHandler.Result.UPKEEP;
    }

    protected void drawFilledCircle(World world, BlockPos pos, int radius, HashMap<ChunkPos, byte[]> chunkMap, WeatherChange weather, int biomeID) {
        int x = radius;
        int radiusError = 1 - x;
        for (int z = 0; x >= z; ++z) {
            this.drawLine(world, pos.add(-x, 0, z), pos.add(x, 0, z), chunkMap, weather, biomeID);
            this.drawLine(world, pos.add(-z, 0, x), pos.add(z, 0, x), chunkMap, weather, biomeID);
            this.drawLine(world, pos.add(-x, 0, -z), pos.add(x, 0, z), chunkMap, weather, biomeID);
            this.drawLine(world, pos.add(-z, 0, -x), pos.add(z, 0, -x), chunkMap, weather, biomeID);
            if (radiusError < 0) {
                radiusError += 2 * z + 1;
                continue;
            }
            radiusError += 2 * (z - --x + 1);
        }
    }

    protected void drawLine(World world, BlockPos x1, BlockPos x2, HashMap<ChunkPos, byte[]> chunkMap, WeatherChange weather, int biomeID) {
        for (BlockPos pos : BlockPos.getAllInBox((BlockPos)x1, (BlockPos)x2)) {
            ChunkPos coord = new ChunkPos(pos);
            byte[] map = chunkMap.get(coord);
            if (map == null) {
                Chunk chunk = world.getChunk(pos);
                map = (byte[])chunk.getBiomeArray().clone();
                chunkMap.put(coord, map);
            }
            map[(pos.getZ() & 0xF) << 4 | pos.getX() & 0xF] = (byte)biomeID;
            if (weather != WeatherChange.SUN || world.getBlockState(pos = world.getTopSolidOrLiquidBlock(pos)).getBlock() != Blocks.SNOW) continue;
            world.setBlockToAir(pos);
        }
    }

    static {
        FOCIS.put((Object)ItemKey.get(Blocks.SAPLING), (Object)BiomeDictionary.Type.FOREST);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.TALLGRASS, 1), (Object)BiomeDictionary.Type.PLAINS);
        FOCIS.put((Object)ItemKey.get(Blocks.STONE), (Object)BiomeDictionary.Type.SAVANNA);
        FOCIS.put((Object)ItemKey.get(Blocks.OBSIDIAN), (Object)BiomeDictionary.Type.MOUNTAIN);
        FOCIS.put((Object)ItemKey.get(Items.SLIME_BALL), (Object)BiomeDictionary.Type.SWAMP);
        FOCIS.put((Object)ItemKey.get(Items.WATER_BUCKET), (Object)BiomeDictionary.Type.OCEAN);
        FOCIS.put((Object)ItemKey.get((Block)WitcheryBlocks.ARTICHOKE_SEEDS), (Object)BiomeDictionary.Type.RIVER);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.CACTUS), (Object)BiomeDictionary.Type.SANDY);
        FOCIS.put((Object)ItemKey.get(WitcheryIngredientItems.ICY_NEEDLE), (Object)BiomeDictionary.Type.SNOWY);
        FOCIS.put((Object)ItemKey.get(Blocks.SAPLING, 3), (Object)BiomeDictionary.Type.JUNGLE);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.SAND), (Object)BiomeDictionary.Type.BEACH);
        FOCIS.put((Object)ItemKey.get((Block)Blocks.RED_MUSHROOM), (Object)BiomeDictionary.Type.MUSHROOM);
    }

    public static enum WeatherChange {
        NONE,
        SUN,
        RAIN,
        THUNDER;

    }
}

