/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.item.ingredients.WitcheryIngredientItem;
import net.msrandom.witchery.potion.PotionEnderInhibition;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectCallCreatures
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectCallCreatures> DESERIALIZER = json -> new RiteEffectCallCreatures(JsonUtils.getFloat((JsonObject)json, (String)"radius", (float)128.0f), JsonUtils.getFloat((JsonObject)json, (String)"height", (float)8.0f), (Set)CollectionsKt.mapTo((Iterable)json.getAsJsonArray("entities"), new HashSet(), it -> ((EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(it.getAsString()))).getEntityClass()));
    private final float radius;
    private final float height;
    private final Set<Class<? extends Entity>> creatureTypes;

    public RiteEffectCallCreatures(float radius, float height2, Set<Class<? extends Entity>> creatureTypes) {
        this.radius = radius;
        this.height = height2;
        this.creatureTypes = creatureTypes;
    }

    private void allure(World world, double posX, double posY, double posZ, int quad) {
        AxisAlignedBB bounds;
        switch (quad) {
            case 0: {
                bounds = new AxisAlignedBB(posX, posY - (double)this.height, posZ - (double)this.radius, posX + (double)this.radius, posY, posZ);
                break;
            }
            case 1: {
                bounds = new AxisAlignedBB(posX - (double)this.radius, posY - (double)this.height, posZ - (double)this.radius, posX, posY, posZ);
                break;
            }
            case 2: {
                bounds = new AxisAlignedBB(posX, posY - (double)this.height, posZ, posX + (double)this.radius, posY, posZ + (double)this.radius);
                break;
            }
            case 3: {
                bounds = new AxisAlignedBB(posX - (double)this.radius, posY - (double)this.height, posZ, posX, posY, posZ + (double)this.radius);
                break;
            }
            case 4: {
                bounds = new AxisAlignedBB(posX - (double)this.radius, posY + 1.0, posZ - (double)this.radius, posX, posY + (double)this.height, posZ);
                break;
            }
            case 5: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ, posX + (double)this.radius, posY + (double)this.height, posZ + (double)this.radius);
                break;
            }
            case 6: {
                bounds = new AxisAlignedBB(posX - (double)this.radius, posY + 1.0, posZ, posX, posY + (double)this.height, posZ + (double)this.radius);
                break;
            }
            default: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ - (double)this.radius, posX + (double)this.radius, posY + (double)this.height, posZ);
            }
        }
        int count = 0;
        int minDistanceSq = 32;
        for (EntityCreature creature : world.getEntitiesWithinAABB(EntityCreature.class, bounds)) {
            if (!this.creatureTypes.contains(creature.getClass()) || !(creature.getDistanceSq(posX, posY, posZ) > (double)minDistanceSq) || !PotionEnderInhibition.canTeleport((Entity)creature, 0)) continue;
            WitcheryIngredientItem.teleportToLocation(posX - 2.0 + (double)world.rand.nextInt(5), posY, posZ - 2.0 + (double)world.rand.nextInt(5), world.provider.getDimension(), (Entity)creature, true);
            if (++count < 2) continue;
            break;
        }
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if ((long)ticks % 60L != 0L) {
            return RiteHandler.Result.STARTING;
        }
        if (!world.isRemote) {
            if (ritual.covenSize < 3) {
                EntityPlayer player = ritual.getInitiatingPlayer(world);
                world.playSound(null, pos, SoundEvents.BLOCK_NOTE_SNARE, player.getSoundCategory(), 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
                player.sendMessage(new TextComponentTranslation("rite.witchery.weak_coven", new Object[0]).setStyle(new Style().setColor(TextFormatting.RED)));
                return RiteHandler.Result.ABORTED_REFUND;
            }
            this.allure(world, pos.getX(), pos.getY(), pos.getZ(), stage.incrementAndGet() % 8);
        }
        return stage.get() < 250 ? RiteHandler.Result.UPKEEP : RiteHandler.Result.COMPLETED;
    }
}

