/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.block.entity.TileEntityCircle;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import net.msrandom.witchery.rite.RiteHandler;
import net.msrandom.witchery.rite.effect.RiteEffect;

public class RiteEffectBroiling
extends RiteEffect {
    public static final Function1<JsonObject, RiteEffectBroiling> DESERIALIZER = json -> {
        JsonElement radius = json.get("radius");
        return new RiteEffectBroiling(radius == null ? 5.0f : radius.getAsFloat(), json.get("burn_chance").getAsDouble());
    };
    private final float radius;
    private final double burnChance;

    public RiteEffectBroiling(float radius, double burnChance) {
        this.radius = radius;
        this.burnChance = burnChance;
    }

    @Override
    public RiteHandler.Result process(World world, BlockPos pos, int ticks, AtomicInteger stage, TileEntityCircle.ActivatedRitual ritual) {
        if (!world.isRemote) {
            List<EntityItem> items = this.getItemsInRadius(world, pos, this.radius);
            int count = 0;
            for (EntityItem item : items) {
                ItemStack cookedStack = FurnaceRecipes.instance().getSmeltingResult(item.getItem());
                if (!(cookedStack.getItem() instanceof ItemFood) || item.getItem().getCount() <= 0) continue;
                int size = item.getItem().getCount();
                int burnCount = 0;
                for (int i = 0; i < size; ++i) {
                    if (!(world.rand.nextDouble() < this.burnChance)) continue;
                    ++burnCount;
                }
                item.setDead();
                if (size - burnCount > 0) {
                    cookedStack.setCount(size - burnCount);
                    EntityItem cookedEntity = new EntityItem(world, (double)pos.getX(), (double)pos.getY() + 0.05, (double)pos.getZ(), cookedStack);
                    cookedEntity.motionX = 0.0;
                    cookedEntity.motionZ = 0.0;
                    world.spawnEntity((Entity)cookedEntity);
                }
                if (burnCount > 0) {
                    EntityItem burntEntity = new EntityItem(world, (double)pos.getX(), (double)pos.getY() + 0.05, (double)pos.getZ(), new ItemStack(Items.COAL, burnCount, 1));
                    burntEntity.motionX = 0.0;
                    burntEntity.motionZ = 0.0;
                    world.spawnEntity((Entity)burntEntity);
                }
                ++count;
            }
            if (count == 0) {
                return RiteHandler.Result.ABORTED_REFUND;
            }
            world.playSound(null, pos, SoundEvents.ENTITY_GHAST_SHOOT, SoundCategory.PLAYERS, 0.5f, 0.4f / (world.rand.nextFloat() * 0.4f + 0.8f));
            WitcheryNetworkChannel.sendToAllAround(new PacketParticles((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 3.0f, 2.0f, EnumParticleTypes.FLAME), world, pos);
        }
        return RiteHandler.Result.COMPLETED;
    }
}

