/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import kotlin.jvm.functions.Function1;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectBlindness
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectBlindness> DESERIALIZER = json -> new RiteEffectBlindness(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)80), JsonUtils.getInt((JsonObject)json, (String)"height", (int)15));

    public RiteEffectBlindness(int radius, int height2) {
        super(radius, height2, true);
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (EntityPlayer victim : world.playerEntities) {
            double distanceSq = victim.getDistanceSq(pos);
            if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
            if (WitcheryPoppetItems.voodooProtectionActivated(player, null, (EntityLivingBase)victim, 6)) {
                return false;
            }
            if (victim.isPotionActive(MobEffects.BLINDNESS)) continue;
            victim.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, (enhanced ? 5 : 2) * 1200, 0));
        }
        for (Entity entity : world.loadedEntityList) {
            EntityLiving victim2;
            double distanceSq;
            if (!(entity instanceof EntityLiving) || (distanceSq = (victim2 = (EntityLiving)entity).getDistanceSq(pos)) <= minSq || distanceSq > radiusSq || victim2.isPotionActive(MobEffects.BLINDNESS)) continue;
            victim2.addPotionEffect(new PotionEffect(MobEffects.BLINDNESS, (enhanced ? 5 : 2) * 1200, 0));
        }
        return true;
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
    }
}

