/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.rite.effect;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import kotlin.jvm.functions.Function1;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.msrandom.witchery.item.WitcheryPoppetItems;
import net.msrandom.witchery.rite.effect.RiteEffectExpandingEffect;

public class RiteEffectBlight
extends RiteEffectExpandingEffect {
    public static final Function1<JsonObject, RiteEffectBlight> DESERIALIZER = json -> new RiteEffectBlight(JsonUtils.getInt((JsonObject)json, (String)"radius", (int)80), JsonUtils.getInt((JsonObject)json, (String)"height", (int)15));

    public RiteEffectBlight(int radius, int height2) {
        super(radius, height2, true);
    }

    @Override
    public boolean doRadiusAction(World world, BlockPos pos, int radius, EntityPlayer player, boolean enhanced) {
        double radiusSq = radius * radius;
        double minSq = Math.max(0, (radius - 1) * (radius - 1));
        for (EntityPlayer victim : world.playerEntities) {
            double distanceSq = victim.getDistanceSq(pos);
            if (!(distanceSq > minSq) || !(distanceSq <= radiusSq)) continue;
            if (WitcheryPoppetItems.voodooProtectionActivated(player, ItemStack.EMPTY, (EntityLivingBase)victim, 6)) {
                return false;
            }
            if (victim.isPotionActive(MobEffects.NAUSEA)) continue;
            victim.addPotionEffect(new PotionEffect(MobEffects.NAUSEA, 2400, 1));
        }
        ArrayList<EntityVillager> villagersToZombify = new ArrayList<EntityVillager>();
        ArrayList<EntityCow> cowsToSchroom = new ArrayList<EntityCow>();
        ArrayList<Object> animalsToSlay = new ArrayList<Object>();
        for (Entity entity : world.loadedEntityList) {
            EntityAnimal victim4;
            double distanceSq2;
            if (entity instanceof EntityVillager) {
                EntityVillager victim2 = (EntityVillager)entity;
                distanceSq2 = victim2.getDistanceSq(pos);
                if (distanceSq2 <= minSq || distanceSq2 > radiusSq || world.rand.nextInt(10) != 0) continue;
                villagersToZombify.add(victim2);
                continue;
            }
            if (entity instanceof EntityCow) {
                EntityCow victim3 = (EntityCow)entity;
                distanceSq2 = victim3.getDistanceSq(pos);
                if (distanceSq2 <= minSq || distanceSq2 > radiusSq) continue;
                if (world.rand.nextInt(20) == 0) {
                    cowsToSchroom.add(victim3);
                    continue;
                }
                if (world.rand.nextInt(3) != 0) continue;
                animalsToSlay.add(victim3);
                continue;
            }
            if (!(entity instanceof EntityAnimal) || (distanceSq2 = (victim4 = (EntityAnimal)entity).getDistanceSq(pos)) <= minSq || distanceSq2 > radiusSq || world.rand.nextInt(3) != 0) continue;
            animalsToSlay.add(victim4);
        }
        for (EntityVillager entityVillager : villagersToZombify) {
            EntityZombieVillager entityzombie = new EntityZombieVillager(world);
            entityzombie.copyLocationAndAnglesFrom((Entity)entityVillager);
            world.removeEntity((Entity)entityVillager);
            entityzombie.onInitialSpawn(world.getDifficultyForLocation(entityzombie.getPosition()), null);
            entityzombie.setForgeProfession(entityVillager.getProfessionForge());
            if (entityVillager.isChild()) {
                entityzombie.setChild(true);
            }
            world.spawnEntity((Entity)entityzombie);
            world.playEvent(1016, entityzombie.getPosition(), 0);
        }
        for (EntityCow entityCow : cowsToSchroom) {
            EntityMooshroom entityzombie2 = new EntityMooshroom(world);
            entityzombie2.copyLocationAndAnglesFrom((Entity)entityCow);
            world.removeEntity((Entity)entityCow);
            entityzombie2.onInitialSpawn(world.getDifficultyForLocation(entityzombie2.getPosition()), null);
            world.spawnEntity((Entity)entityzombie2);
            world.playEvent(1016, entityzombie2.getPosition(), 0);
        }
        for (EntityAnimal entityAnimal : animalsToSlay) {
            entityAnimal.attackEntityFrom(DamageSource.MAGIC, 20.0f);
        }
        return true;
    }

    @Override
    public void doBlockAction(World world, BlockPos pos, int currentRadius, EntityPlayer player, boolean enhanced) {
        if (!world.isRemote) {
            BlockPos down = pos.down();
            IBlockState state = world.getBlockState(pos);
            IBlockState stateBelow = world.getBlockState(down);
            Block blockID = state.getBlock();
            Block blockBelowID = stateBelow.getBlock();
            if (blockID == Blocks.TALLGRASS) {
                world.setBlockToAir(pos);
                this.blightGround(world, down, blockBelowID, enhanced);
            } else if (blockID == Blocks.RED_FLOWER || blockID == Blocks.YELLOW_FLOWER || blockID == Blocks.CARROTS || blockID == Blocks.WHEAT || blockID == Blocks.POTATOES || blockID == Blocks.PUMPKIN_STEM || blockID == Blocks.MELON_STEM || blockID == Blocks.MELON_BLOCK || blockID == Blocks.PUMPKIN) {
                world.setBlockState(pos, Blocks.DEADBUSH.getDefaultState());
                this.blightGround(world, down, blockBelowID, enhanced);
            } else if (blockID == Blocks.FARMLAND) {
                world.setBlockState(pos, Blocks.SAND.getDefaultState());
            } else if (state.getMaterial().isSolid()) {
                this.blightGround(world, pos, blockID, enhanced);
            } else if (stateBelow.getMaterial().isSolid()) {
                this.blightGround(world, down, blockBelowID, enhanced);
            }
        }
    }

    public void blightGround(World world, BlockPos pos, Block blockBelowID, boolean enhanced) {
        if (blockBelowID == Blocks.DIRT || blockBelowID == Blocks.GRASS || blockBelowID == Blocks.MYCELIUM || blockBelowID == Blocks.FARMLAND) {
            int rand = world.rand.nextInt(enhanced ? 4 : 5);
            if (rand == 0) {
                world.setBlockState(pos, Blocks.SAND.getDefaultState());
            } else if (rand == 1) {
                world.setBlockState(pos, Blocks.DIRT.getDefaultState());
            }
        }
    }
}

